/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.jenkins.plugins.hetzner.HetznerCloud;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerAgent;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerInfo;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import hudson.model.Node;
import hudson.slaves.SlaveComputer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeCallable
implements Callable<Node> {
    private static final Logger log = LoggerFactory.getLogger(NodeCallable.class);
    private final HetznerServerAgent agent;
    private final HetznerCloud cloud;

    @Override
    public Node call() throws Exception {
        SlaveComputer computer = this.agent.getComputer();
        if (computer != null && computer.isOnline()) {
            return this.agent;
        }
        HetznerServerInfo serverInfo = this.cloud.getResourceManager().createServer(this.agent);
        this.agent.setServerInstance(serverInfo);
        String serverName = serverInfo.getServerDetail().getName();
        boolean running = false;
        int bootDeadline = this.agent.getTemplate().getBootDeadline();
        WaitStrategy waitStrategy = new WaitStrategy(bootDeadline, 45, 15);
        while (!waitStrategy.isDeadLineOver()) {
            waitStrategy.waitNext();
            if (!this.agent.isAlive()) continue;
            log.info("Server '{}' is now running, waiting 10 seconds before proceeding", (Object)serverName);
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            running = true;
            break;
        }
        Preconditions.checkState((boolean)running, (String)"Server '%s' didn't start after 15 minutes, giving up", (Object)serverName);
        Jenkins.get().addNode((Node)this.agent);
        computer = this.agent.toComputer();
        int retry = 5;
        boolean connected = false;
        if (computer != null) {
            while (--retry > 0) {
                try {
                    computer.connect(false).get();
                    connected = true;
                    break;
                }
                catch (InterruptedException | ExecutionException e) {
                    log.warn("Connection to '{}' has failed, remaining retries {}", new Object[]{computer.getDisplayName(), retry, e});
                    TimeUnit.SECONDS.sleep(10L);
                }
            }
            if (!connected) {
                throw new IllegalStateException("Computer is not connected : " + computer.getName());
            }
        } else {
            throw new IllegalStateException("No computer object in agent " + this.agent.getDisplayName());
        }
        return this.agent;
    }

    public NodeCallable(HetznerServerAgent agent, HetznerCloud cloud) {
        this.agent = agent;
        this.cloud = cloud;
    }

    private static final class WaitStrategy {
        private final int firstInterval;
        private final int subsequentIntervals;
        private final long deadlineNanos;
        private boolean first = true;

        private WaitStrategy(int deadlineMinutes, int firstInterval, int subsequentIntervals) {
            this.deadlineNanos = System.nanoTime() + (long)deadlineMinutes * 60L * 1000000000L;
            this.firstInterval = firstInterval;
            this.subsequentIntervals = subsequentIntervals;
        }

        boolean isDeadLineOver() {
            return System.nanoTime() > this.deadlineNanos;
        }

        void waitNext() {
            int waitSeconds;
            if (this.first) {
                this.first = false;
                waitSeconds = this.firstInterval;
            } else {
                waitSeconds = this.subsequentIntervals;
            }
            Uninterruptibles.sleepUninterruptibly((long)waitSeconds, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

