/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.jenkins.plugins.hetzner.ConfigurationValidator;
import cloud.dnation.jenkins.plugins.hetzner.Helper;
import cloud.dnation.jenkins.plugins.hetzner.HetznerCloud;
import cloud.dnation.jenkins.plugins.hetzner.HetznerConstants;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerAgent;
import cloud.dnation.jenkins.plugins.hetzner.Messages;
import cloud.dnation.jenkins.plugins.hetzner.connect.AbstractConnectivity;
import cloud.dnation.jenkins.plugins.hetzner.launcher.AbstractHetznerSshConnector;
import cloud.dnation.jenkins.plugins.hetzner.primaryip.AbstractPrimaryIpStrategy;
import cloud.dnation.jenkins.plugins.hetzner.shutdown.AbstractShutdownPolicy;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HetznerServerTemplate
extends AbstractDescribableImpl<HetznerServerTemplate> {
    private static final Logger log = LoggerFactory.getLogger(HetznerServerTemplate.class);
    private static final Pattern PREFIX_RE = Pattern.compile("^[a-z][\\w_-]+$");
    private final String name;
    private final String labelStr;
    private final String image;
    private final String location;
    private final String serverType;
    private transient Set<LabelAtom> labels;
    @NonNull
    private transient HetznerCloud cloud;
    private AbstractHetznerSshConnector connector;
    private String remoteFs;
    private String placementGroup;
    private String userData;
    private String jvmOpts;
    private int numExecutors;
    private int bootDeadline;
    private String network;
    private String firewall;
    private String prefix;
    private Node.Mode mode = Node.Mode.EXCLUSIVE;
    private AbstractShutdownPolicy shutdownPolicy;
    private AbstractPrimaryIpStrategy primaryIp;
    private AbstractConnectivity connectivity;
    private boolean automountVolumes;
    private String volumeIds;

    @DataBoundConstructor
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public HetznerServerTemplate(String name, String labelStr, String image, String location, String serverType) {
        this.name = name;
        this.labelStr = Util.fixNull((String)labelStr);
        this.image = image;
        this.location = location;
        this.serverType = serverType;
        this.readResolve();
    }

    protected Object readResolve() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.labels = Label.parse((String)this.labelStr);
        if (Strings.isNullOrEmpty((String)this.location)) {
            throw new IllegalArgumentException("Location must be specified");
        }
        if (this.numExecutors == 0) {
            this.setNumExecutors(1);
        }
        if (this.bootDeadline == 0) {
            this.setBootDeadline(1);
        }
        if (this.shutdownPolicy == null) {
            this.shutdownPolicy = HetznerConstants.DEFAULT_SHUTDOWN_POLICY;
        }
        if (this.primaryIp == null) {
            this.primaryIp = HetznerConstants.DEFAULT_PRIMARY_IP_STRATEGY;
        }
        if (this.connectivity == null) {
            this.connectivity = HetznerConstants.DEFAULT_CONNECTIVITY;
        }
        if (this.placementGroup == null) {
            this.placementGroup = "";
        }
        if (this.userData == null) {
            this.userData = "";
        }
        if (this.volumeIds == null) {
            this.volumeIds = "";
        }
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.prefix = this.prefix.toLowerCase(Locale.ROOT);
        return this;
    }

    boolean isPrefixValid() {
        return HetznerServerTemplate.checkPrefixValue(this.prefix);
    }

    static boolean checkPrefixValue(String prefixStr) {
        return PREFIX_RE.matcher(prefixStr).matches();
    }

    String generateNodeName() {
        String prefixStr = this.isPrefixValid() ? this.prefix : "hcloud";
        return prefixStr + "-" + RandomStringUtils.randomAlphanumeric((int)16).toLowerCase(Locale.ROOT);
    }

    HetznerServerAgent createAgent(ProvisioningActivity.Id provisioningId, String nodeName) throws IOException, Descriptor.FormException {
        return new HetznerServerAgent(provisioningId, nodeName, Helper.getStringOrDefault(this.remoteFs, "/home/jenkins"), this.connector.createLauncher(), this.cloud, this);
    }

    public String toString() {
        return "HetznerServerTemplate(name=" + this.getName() + ", labelStr=" + this.getLabelStr() + ", image=" + this.getImage() + ", location=" + this.getLocation() + ", serverType=" + this.getServerType() + ", labels=" + String.valueOf(this.getLabels()) + ", cloud=" + String.valueOf((Object)this.getCloud()) + ", connector=" + String.valueOf((Object)this.getConnector()) + ", remoteFs=" + this.getRemoteFs() + ", placementGroup=" + this.getPlacementGroup() + ", userData=" + this.getUserData() + ", jvmOpts=" + this.getJvmOpts() + ", numExecutors=" + this.getNumExecutors() + ", bootDeadline=" + this.getBootDeadline() + ", network=" + this.getNetwork() + ", firewall=" + this.getFirewall() + ", prefix=" + this.getPrefix() + ", mode=" + String.valueOf(this.getMode()) + ", shutdownPolicy=" + String.valueOf((Object)this.getShutdownPolicy()) + ", primaryIp=" + String.valueOf((Object)this.getPrimaryIp()) + ", connectivity=" + String.valueOf((Object)this.getConnectivity()) + ", automountVolumes=" + this.isAutomountVolumes() + ", volumeIds=" + this.getVolumeIds() + ")";
    }

    public String getName() {
        return this.name;
    }

    public String getLabelStr() {
        return this.labelStr;
    }

    public String getImage() {
        return this.image;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServerType() {
        return this.serverType;
    }

    public Set<LabelAtom> getLabels() {
        return this.labels;
    }

    void setCloud(@NonNull HetznerCloud cloud) {
        if (cloud == null) {
            throw new NullPointerException("cloud is marked non-null but is null");
        }
        this.cloud = cloud;
    }

    @NonNull
    HetznerCloud getCloud() {
        return this.cloud;
    }

    @DataBoundSetter
    public void setConnector(AbstractHetznerSshConnector connector) {
        this.connector = connector;
    }

    public AbstractHetznerSshConnector getConnector() {
        return this.connector;
    }

    @DataBoundSetter
    public void setRemoteFs(String remoteFs) {
        this.remoteFs = remoteFs;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    @DataBoundSetter
    public void setPlacementGroup(String placementGroup) {
        this.placementGroup = placementGroup;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    @DataBoundSetter
    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    @DataBoundSetter
    public void setJvmOpts(String jvmOpts) {
        this.jvmOpts = jvmOpts;
    }

    public String getJvmOpts() {
        return this.jvmOpts;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    @DataBoundSetter
    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors;
    }

    public int getBootDeadline() {
        return this.bootDeadline;
    }

    @DataBoundSetter
    public void setBootDeadline(int bootDeadline) {
        this.bootDeadline = bootDeadline;
    }

    public String getNetwork() {
        return this.network;
    }

    @DataBoundSetter
    public void setNetwork(String network) {
        this.network = network;
    }

    public String getFirewall() {
        return this.firewall;
    }

    @DataBoundSetter
    public void setFirewall(String firewall) {
        this.firewall = firewall;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @DataBoundSetter
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    public AbstractShutdownPolicy getShutdownPolicy() {
        return this.shutdownPolicy;
    }

    @DataBoundSetter
    public void setShutdownPolicy(AbstractShutdownPolicy shutdownPolicy) {
        this.shutdownPolicy = shutdownPolicy;
    }

    public AbstractPrimaryIpStrategy getPrimaryIp() {
        return this.primaryIp;
    }

    @DataBoundSetter
    public void setPrimaryIp(AbstractPrimaryIpStrategy primaryIp) {
        this.primaryIp = primaryIp;
    }

    public AbstractConnectivity getConnectivity() {
        return this.connectivity;
    }

    @DataBoundSetter
    public void setConnectivity(AbstractConnectivity connectivity) {
        this.connectivity = connectivity;
    }

    public boolean isAutomountVolumes() {
        return this.automountVolumes;
    }

    @DataBoundSetter
    public void setAutomountVolumes(boolean automountVolumes) {
        this.automountVolumes = automountVolumes;
    }

    public String getVolumeIds() {
        return this.volumeIds;
    }

    @DataBoundSetter
    public void setVolumeIds(String volumeIds) {
        this.volumeIds = volumeIds;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<HetznerServerTemplate> {
        @NonNull
        public String getDisplayName() {
            return Messages.serverTemplate_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyPrefix(@QueryParameter String prefix) {
            return ConfigurationValidator.verifyPrefix(prefix);
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyLocation(@QueryParameter String location, @QueryParameter String credentialsId) {
            return ConfigurationValidator.verifyLocation(location, credentialsId).toFormValidation();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyImage(@QueryParameter String image, @QueryParameter String credentialsId) {
            return ConfigurationValidator.verifyImage(image, credentialsId).toFormValidation();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyNetwork(@QueryParameter String network, @QueryParameter String credentialsId) {
            return ConfigurationValidator.verifyNetwork(network, credentialsId).toFormValidation();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyFirewall(@QueryParameter String firewall, @QueryParameter String credentialsId) {
            return ConfigurationValidator.verifyFirewall(firewall, credentialsId).toFormValidation();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyPlacementGroup(@QueryParameter String placementGroup, @QueryParameter String credentialsId) {
            return ConfigurationValidator.verifyPlacementGroup(placementGroup, credentialsId).toFormValidation();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyServerType(@QueryParameter String serverType, @QueryParameter String credentialsId) {
            return ConfigurationValidator.verifyServerType(serverType, credentialsId).toFormValidation();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyVolumes(@QueryParameter String volumeIds, @QueryParameter String credentialsId) {
            return ConfigurationValidator.verifyVolumes(volumeIds, credentialsId).toFormValidation();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckImage(@QueryParameter String image) {
            return ConfigurationValidator.doCheckNonEmpty(image, "Image");
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckLabelStr(@QueryParameter String labelStr, @QueryParameter Node.Mode mode) {
            if (Strings.isNullOrEmpty((String)labelStr) && Node.Mode.EXCLUSIVE == mode) {
                return FormValidation.warning((String)"You may want to assign labels to this node; it's marked to only run jobs that are exclusively tied to itself or a label.");
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckServerType(@QueryParameter String serverType) {
            return ConfigurationValidator.doCheckNonEmpty(serverType, "Server type");
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckLocation(@QueryParameter String location) {
            return ConfigurationValidator.doCheckNonEmpty(location, "Location");
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckName(@QueryParameter String name) {
            return ConfigurationValidator.doCheckNonEmpty(name, "Name");
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckNumExecutors(@QueryParameter String numExecutors) {
            return ConfigurationValidator.doCheckPositiveInt(numExecutors, "Number of executors");
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckBootDeadline(@QueryParameter String bootDeadline) {
            return ConfigurationValidator.doCheckPositiveInt(bootDeadline, "Boot deadline");
        }
    }
}

