/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.jenkins.plugins.hetzner.HetznerCloud;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerComputer;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerInfo;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerTemplate;
import cloud.dnation.jenkins.plugins.hetzner.Messages;
import cloud.dnation.jenkins.plugins.hetzner.launcher.HetznerServerComputerLauncher;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EphemeralNode;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HetznerServerAgent
extends AbstractCloudSlave
implements EphemeralNode,
TrackedItem {
    private static final Logger log = LoggerFactory.getLogger(HetznerServerAgent.class);
    private static final long serialVersionUID = 1L;
    private final ProvisioningActivity.Id provisioningId;
    private final transient HetznerCloud cloud;
    @NonNull
    private final transient HetznerServerTemplate template;
    private transient HetznerServerInfo serverInstance;

    public HetznerServerAgent(@NonNull ProvisioningActivity.Id provisioningId, @NonNull String name, String remoteFS, ComputerLauncher launcher, @NonNull HetznerCloud cloud, @NonNull HetznerServerTemplate template) throws IOException, Descriptor.FormException {
        super(name, remoteFS, launcher);
        this.cloud = Objects.requireNonNull(cloud);
        this.template = Objects.requireNonNull(template);
        this.provisioningId = Objects.requireNonNull(provisioningId);
        this.setLabelString(template.getLabelStr());
        this.setNumExecutors(template.getNumExecutors());
        this.setMode(template.getMode() == null ? Node.Mode.EXCLUSIVE : template.getMode());
        this.setRetentionStrategy(template.getShutdownPolicy().getRetentionStrategy());
        this.readResolve();
    }

    public AbstractCloudComputer createComputer() {
        return new HetznerServerComputer(this);
    }

    public String getDisplayName() {
        if (this.serverInstance != null && this.serverInstance.getServerDetail() != null) {
            return this.getNodeName() + " in " + this.serverInstance.getServerDetail().getDatacenter().getLocation().getDescription();
        }
        return super.getDisplayName();
    }

    protected void _terminate(TaskListener listener) {
        ((HetznerServerComputerLauncher)this.getLauncher()).signalTermination();
        this.cloud.getResourceManager().destroyServer(this.serverInstance.getServerDetail());
        Optional.ofNullable(CloudStatistics.get().getActivityFor((TrackedItem)this)).ifPresent(a -> a.enterIfNotAlready(ProvisioningActivity.Phase.COMPLETED));
    }

    public Node asNode() {
        return this;
    }

    @NonNull
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    public boolean isAlive() {
        this.serverInstance = this.cloud.getResourceManager().refreshServerInfo(this.serverInstance);
        return this.serverInstance.getServerDetail().getStatus().equals("running");
    }

    public HetznerCloud getCloud() {
        return this.cloud;
    }

    @NonNull
    public HetznerServerTemplate getTemplate() {
        return this.template;
    }

    public HetznerServerInfo getServerInstance() {
        return this.serverInstance;
    }

    void setServerInstance(HetznerServerInfo serverInstance) {
        this.serverInstance = serverInstance;
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.plugin_displayName();
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

