/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.hetznerclient.AbstractSearchResponse;
import cloud.dnation.hetznerclient.ClientFactory;
import cloud.dnation.hetznerclient.CreateServerFirewallsRequest;
import cloud.dnation.hetznerclient.CreateServerRequest;
import cloud.dnation.hetznerclient.CreateServerResponse;
import cloud.dnation.hetznerclient.CreateSshKeyRequest;
import cloud.dnation.hetznerclient.CreateSshKeyResponse;
import cloud.dnation.hetznerclient.GetFirewallsBySelectorResponse;
import cloud.dnation.hetznerclient.GetImagesBySelectorResponse;
import cloud.dnation.hetznerclient.GetNetworksBySelectorResponse;
import cloud.dnation.hetznerclient.GetPlacementGroupsResponse;
import cloud.dnation.hetznerclient.GetServerByIdResponse;
import cloud.dnation.hetznerclient.GetServersBySelectorResponse;
import cloud.dnation.hetznerclient.GetSshKeysBySelectorResponse;
import cloud.dnation.hetznerclient.HetznerApi;
import cloud.dnation.hetznerclient.IdentifiableResource;
import cloud.dnation.hetznerclient.Meta;
import cloud.dnation.hetznerclient.PublicNetRequest;
import cloud.dnation.hetznerclient.ServerDetail;
import cloud.dnation.hetznerclient.SshKeyDetail;
import cloud.dnation.jenkins.plugins.hetzner.Helper;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerAgent;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerInfo;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerTemplate;
import cloud.dnation.jenkins.plugins.hetzner.JenkinsSecretTokenProvider;
import cloud.dnation.jenkins.plugins.hetzner.connect.ConnectivityType;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class HetznerCloudResourceManager {
    private static final Logger log = LoggerFactory.getLogger(HetznerCloudResourceManager.class);
    @NonNull
    private final String credentialsId;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public static HetznerCloudResourceManager create(String credentialsId) {
        return new HetznerCloudResourceManager(credentialsId);
    }

    private static Map<String, String> createLabelsForServer(String cloudName) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        ret.put("jenkins.io/managed-by", "hetzner-jenkins-plugin");
        ret.put("jenkins.io/cloud-name", cloudName);
        return ret;
    }

    private static Map<String, String> createLabelsForSshKey(String credentialsId) {
        return ImmutableMap.builder().put((Object)"jenkins.io/managed-by", (Object)"hetzner-jenkins-plugin").put((Object)"jenkins.io/credentials-id", (Object)credentialsId).build();
    }

    @VisibleForTesting
    static String buildLabelExpressionForSshKey(String credentialsId) {
        return HetznerCloudResourceManager.createLabelsForSshKey(credentialsId).entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
    }

    private HetznerApi proxy() {
        return ClientFactory.create((Supplier)JenkinsSecretTokenProvider.forCredentialsId(this.credentialsId));
    }

    private long getImageIdForLabelExpression(String labelExpression) throws IOException {
        return this.searchResourceByLabelExpression(labelExpression, arg_0 -> ((HetznerApi)this.proxy()).getImagesBySelector(arg_0), GetImagesBySelectorResponse::getImages);
    }

    private long getNetworkIdForLabelExpression(String labelExpression) throws IOException {
        return this.searchResourceByLabelExpression(labelExpression, arg_0 -> ((HetznerApi)this.proxy()).getNetworkBySelector(arg_0), GetNetworksBySelectorResponse::getNetworks);
    }

    private long getFirewallIdForLabelExpression(String labelExpression) throws IOException {
        return this.searchResourceByLabelExpression(labelExpression, arg_0 -> ((HetznerApi)this.proxy()).getFirewallsBySelector(arg_0), GetFirewallsBySelectorResponse::getFirewalls);
    }

    private long getPlacementGroupForLabelExpression(String labelExpression) throws IOException {
        return this.searchResourceByLabelExpression(labelExpression, arg_0 -> ((HetznerApi)this.proxy()).getPlacementGroups(arg_0), GetPlacementGroupsResponse::getPlacementGroups);
    }

    private <R extends AbstractSearchResponse, I extends IdentifiableResource> long searchResourceByLabelExpression(String labelExpression, Function<String, Call<R>> searchFunction, Function<R, List<I>> getItemsFunction) throws IOException {
        log.info("Trying to find single resource for label expression '{}'", (Object)labelExpression);
        Response response = searchFunction.apply(labelExpression).execute();
        Helper.assertValidResponse(response);
        List<I> items = Helper.getPayload(response, getItemsFunction);
        Preconditions.checkArgument((items.size() == 1 ? 1 : 0) != 0, (String)"No exact match found for expression '%s', results %d", (Object)labelExpression, (int)items.size());
        return ((IdentifiableResource)Iterables.getOnlyElement(items)).getId();
    }

    public void destroyServer(ServerDetail server) {
        long serverId = server.getId();
        HetznerApi client = this.proxy();
        try {
            Helper.assertValidResponse(client.powerOffServer(serverId).execute());
            log.info("Power off initiated for server with ID = {}, waiting for shutdown...", (Object)serverId);
            boolean isShutdown = false;
            int maxAttempts = 60;
            for (int attempts = 0; !isShutdown && attempts < 60; ++attempts) {
                try {
                    Thread.sleep(5000L);
                    Response response = client.getServer(serverId).execute();
                    if (!response.isSuccessful() || response.body() == null) continue;
                    ServerDetail currentState = ((GetServerByIdResponse)response.body()).getServer();
                    if ("off".equals(currentState.getStatus())) {
                        isShutdown = true;
                        log.info("Server with ID = {} is now powered off, proceeding with deletion", (Object)serverId);
                        continue;
                    }
                    log.debug("Server with ID = {} is still in '{}' status, waiting...", (Object)serverId, (Object)currentState.getStatus());
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted while waiting for server shutdown", (Throwable)e);
                    break;
                }
            }
            if (!isShutdown) {
                log.warn("Server with ID = {} did not power off within expected time, proceeding with deletion anyway", (Object)serverId);
            }
            Helper.assertValidResponse(client.deleteServer(serverId).execute());
            log.info("Server with ID = {} successfully deleted", (Object)serverId);
        }
        catch (IOException e) {
            log.error("Unable to destroy server with ID = {}", (Object)serverId, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    private SshKeyDetail getOrCreateSshKey(HetznerServerTemplate template) throws IOException {
        HetznerApi client = this.proxy();
        String credentialsId = template.getConnector().getSshCredentialsId();
        BasicSSHUserPrivateKey privateKey = Helper.assertSshKey(credentialsId);
        Response searchResponse = client.getSshKeysBySelector(HetznerCloudResourceManager.buildLabelExpressionForSshKey(credentialsId)).execute();
        Helper.assertValidResponse(searchResponse);
        List sshKeys = Helper.getPayload(searchResponse, GetSshKeysBySelectorResponse::getSshKeys);
        if (!sshKeys.isEmpty()) {
            return (SshKeyDetail)Iterables.getOnlyElement(sshKeys);
        }
        String publicKey = Helper.getSSHPublicKeyFromPrivate(privateKey.getPrivateKey(), Secret.toString((Secret)privateKey.getPassphrase()));
        Response createResponse = this.proxy().createSshKey(new CreateSshKeyRequest().labels(HetznerCloudResourceManager.createLabelsForSshKey(credentialsId)).name(template.getConnector().getSshCredentialsId()).publicKey(publicKey)).execute();
        return Helper.assertValidResponse(createResponse, CreateSshKeyResponse::getSshKey);
    }

    public HetznerServerInfo refreshServerInfo(HetznerServerInfo info) {
        try {
            Response response = this.proxy().getServer(info.getServerDetail().getId().longValue()).execute();
            info.setServerDetail(Helper.assertValidResponse(response, GetServerByIdResponse::getServer));
            return info;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void configurePrivateNetwork(CreateServerRequest req, String network) {
        if (!Strings.isNullOrEmpty((String)network)) {
            long networkId = Helper.isPossiblyLong(network) ? Long.parseLong(network) : this.getNetworkIdForLabelExpression(network);
            req.setNetworks((List)Lists.newArrayList((Object[])new Long[]{networkId}));
        }
    }

    @VisibleForTesting
    static void customizeNetworking(ConnectivityType ct, CreateServerRequest req, String network, BiConsumer<CreateServerRequest, String> privateNetConfig) throws IOException {
        req.setPublicNet(new PublicNetRequest());
        req.getPublicNet().setEnableIpv4(Boolean.valueOf(false));
        req.getPublicNet().setEnableIpv6(Boolean.valueOf(false));
        switch (ct) {
            case PRIVATE: {
                privateNetConfig.accept(req, network);
                break;
            }
            case BOTH: {
                req.getPublicNet().setEnableIpv4(Boolean.valueOf(true));
                req.getPublicNet().setEnableIpv6(Boolean.valueOf(true));
                privateNetConfig.accept(req, network);
                break;
            }
            case BOTH_V6: {
                req.getPublicNet().setEnableIpv6(Boolean.valueOf(true));
                privateNetConfig.accept(req, network);
                break;
            }
            case PUBLIC: {
                req.getPublicNet().setEnableIpv4(Boolean.valueOf(true));
                req.getPublicNet().setEnableIpv6(Boolean.valueOf(true));
                break;
            }
            case PUBLIC_V6: {
                req.getPublicNet().setEnableIpv6(Boolean.valueOf(true));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown connectivity type: " + String.valueOf((Object)ct));
            }
        }
    }

    public HetznerServerInfo createServer(HetznerServerAgent agent) {
        try {
            this.lock.writeLock().lock();
            SshKeyDetail sshKey = this.getOrCreateSshKey(agent.getTemplate());
            String imageId = agent.getTemplate().getImage().contains("=") ? String.valueOf(this.getImageIdForLabelExpression(agent.getTemplate().getImage())) : agent.getTemplate().getImage();
            CreateServerRequest createServerRequest = new CreateServerRequest();
            if (agent.getTemplate().isAutomountVolumes()) {
                createServerRequest.setAutomount(Boolean.valueOf(true));
            }
            if (!Strings.isNullOrEmpty((String)agent.getTemplate().getVolumeIds())) {
                createServerRequest.setVolumes(Helper.idList(agent.getTemplate().getVolumeIds()));
            }
            ConnectivityType ct = agent.getTemplate().getConnectivity().getType();
            HetznerCloudResourceManager.customizeNetworking(ct, createServerRequest, agent.getTemplate().getNetwork(), this::configurePrivateNetwork);
            String placementGroup = agent.getTemplate().getPlacementGroup();
            if (!Strings.isNullOrEmpty((String)placementGroup)) {
                if (Helper.isPossiblyLong(placementGroup)) {
                    createServerRequest.setPlacementGroup(Long.valueOf(Long.parseLong(placementGroup)));
                } else {
                    createServerRequest.setPlacementGroup(Long.valueOf(this.getPlacementGroupForLabelExpression(placementGroup)));
                }
            }
            String firewall = agent.getTemplate().getFirewall();
            if (!Strings.isNullOrEmpty((String)agent.getTemplate().getFirewall())) {
                if (Helper.isPossiblyLong(firewall)) {
                    createServerRequest.setFirewalls(List.of(new CreateServerFirewallsRequest().firewall(Long.valueOf(Long.parseLong(firewall)))));
                } else {
                    createServerRequest.setFirewalls(List.of(new CreateServerFirewallsRequest().firewall(Long.valueOf(this.getFirewallIdForLabelExpression(firewall)))));
                }
            }
            if (!Strings.isNullOrEmpty((String)agent.getTemplate().getUserData())) {
                createServerRequest.setUserData(agent.getTemplate().getUserData());
            }
            createServerRequest.setServerType(agent.getTemplate().getServerType());
            createServerRequest.setImage(imageId);
            createServerRequest.setName(agent.getNodeName());
            createServerRequest.setSshKeys(Collections.singletonList(sshKey.getName()));
            if (agent.getTemplate().getLocation().contains("-")) {
                createServerRequest.setDatacenter(agent.getTemplate().getLocation());
            } else {
                createServerRequest.setLocation(agent.getTemplate().getLocation());
            }
            createServerRequest.setLabels(HetznerCloudResourceManager.createLabelsForServer(agent.getTemplate().getCloud().name));
            if (ct == ConnectivityType.BOTH || ct == ConnectivityType.PUBLIC_V6 || ct == ConnectivityType.PUBLIC) {
                Optional.of(agent.getTemplate().getPrimaryIp()).ifPresent(ip -> ip.apply(this.proxy(), createServerRequest));
            }
            log.debug("Calling API to create server resource : {}", (Object)createServerRequest);
            Response createServerResponse = this.proxy().createServer(createServerRequest).execute();
            HetznerServerInfo info = new HetznerServerInfo(sshKey);
            info.setServerDetail(Helper.assertValidResponse(createServerResponse, CreateServerResponse::getServer));
            HetznerServerInfo hetznerServerInfo = info;
            return hetznerServerInfo;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<ServerDetail> fetchAllServers(String cloudName) throws IOException {
        ArrayList<ServerDetail> result = new ArrayList<ServerDetail>();
        HetznerApi client = this.proxy();
        String selector = HetznerCloudResourceManager.createLabelsForServer(cloudName).entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
        int page = 1;
        while (true) {
            Response pagedResult = client.getServersBySelector(selector, page, 50).execute();
            Helper.assertValidResponse(pagedResult);
            Meta meta = ((GetServersBySelectorResponse)pagedResult.body()).getMeta();
            List currentPage = ((GetServersBySelectorResponse)pagedResult.body()).getServers();
            result.addAll(currentPage);
            if (meta.getPagination().getNextPage() == null) break;
            ++page;
        }
        return result;
    }

    public HetznerCloudResourceManager(@NonNull String credentialsId) {
        if (credentialsId == null) {
            throw new NullPointerException("credentialsId is marked non-null but is null");
        }
        this.credentialsId = credentialsId;
    }
}

