/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.jenkins.plugins.hetzner.ConfigurationValidator;
import cloud.dnation.jenkins.plugins.hetzner.Helper;
import cloud.dnation.jenkins.plugins.hetzner.HetznerCloudResourceManager;
import cloud.dnation.jenkins.plugins.hetzner.HetznerConstants;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerAgent;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerTemplate;
import cloud.dnation.jenkins.plugins.hetzner.Messages;
import cloud.dnation.jenkins.plugins.hetzner.NodeCallable;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.primitives.Ints;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.slaves.AbstractCloudImpl;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedPlannedNode;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HetznerCloud
extends AbstractCloudImpl {
    private static final Logger log = LoggerFactory.getLogger(HetznerCloud.class);
    private final String credentialsId;
    private List<HetznerServerTemplate> serverTemplates;
    private transient HetznerCloudResourceManager resourceManager;

    @DataBoundConstructor
    public HetznerCloud(String name, String credentialsId, String instanceCapStr, List<HetznerServerTemplate> serverTemplates) {
        super(name, instanceCapStr);
        this.credentialsId = credentialsId;
        this.serverTemplates = serverTemplates;
        this.readResolve();
    }

    private static HetznerServerTemplate pickTemplate(List<HetznerServerTemplate> matchingTemplates) {
        if (matchingTemplates.size() == 1) {
            return matchingTemplates.get(0);
        }
        ArrayList<HetznerServerTemplate> shuffled = new ArrayList<HetznerServerTemplate>(matchingTemplates);
        Collections.shuffle(shuffled);
        return (HetznerServerTemplate)((Object)shuffled.get(0));
    }

    @DataBoundSetter
    public void setServerTemplates(List<HetznerServerTemplate> serverTemplates) {
        this.serverTemplates = Objects.requireNonNullElse(serverTemplates, Collections.emptyList());
        this.readResolve();
    }

    protected Object readResolve() {
        this.resourceManager = HetznerCloudResourceManager.create(this.credentialsId);
        if (this.serverTemplates == null) {
            this.setServerTemplates(Collections.emptyList());
        }
        for (HetznerServerTemplate template : this.serverTemplates) {
            template.setCloud(this);
            template.readResolve();
        }
        return this;
    }

    private int runningNodeCount() {
        return Ints.checkedCast((long)this.resourceManager.fetchAllServers(this.name).stream().filter(sd -> HetznerConstants.RUNNABLE_STATE_SET.contains(sd.getStatus())).count());
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Cloud.CloudState state, int excessWorkload) {
        log.debug("provision(cloud={},label={},excessWorkload={})", new Object[]{this.name, state.getLabel(), excessWorkload});
        ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>();
        Label label = state.getLabel();
        List<HetznerServerTemplate> matchingTemplates = this.getTemplates(label);
        Jenkins jenkinsInstance = Jenkins.get();
        try {
            while (excessWorkload > 0) {
                if (jenkinsInstance.isQuietingDown() || jenkinsInstance.isTerminating()) {
                    log.warn("Jenkins is going down, no new nodes will be provisioned");
                    break;
                }
                int running = this.runningNodeCount();
                int instanceCap = this.getInstanceCap();
                int available = instanceCap - running;
                HetznerServerTemplate template = HetznerCloud.pickTemplate(matchingTemplates);
                log.info("Creating new agent with {} executors, have {} running VMs", (Object)template.getNumExecutors(), (Object)running);
                if (available <= 0) {
                    log.warn("Cloud capacity reached ({}). Has {} VMs running, but want {} more executors", new Object[]{instanceCap, running, excessWorkload});
                    break;
                }
                String serverName = template.generateNodeName();
                ProvisioningActivity.Id provisioningId = new ProvisioningActivity.Id(this.name, template.getName(), serverName);
                HetznerServerAgent agent = template.createAgent(provisioningId, serverName);
                agent.setMode(template.getMode());
                plannedNodes.add((NodeProvisioner.PlannedNode)new TrackedPlannedNode(provisioningId, agent.getNumExecutors(), Computer.threadPoolForRemoting.submit(new NodeCallable(agent, this))));
                excessWorkload -= agent.getNumExecutors();
            }
        }
        catch (Descriptor.FormException | IOException e) {
            log.error("Unable to provision node", e);
        }
        return plannedNodes;
    }

    public boolean canProvision(Cloud.CloudState state) {
        return !this.getTemplates(state.getLabel()).isEmpty();
    }

    private List<HetznerServerTemplate> getTemplates(Label label) {
        return this.serverTemplates.stream().filter(t -> {
            if (t.getLabels().isEmpty()) {
                return Node.Mode.NORMAL.equals((Object)t.getMode());
            }
            if (Node.Mode.NORMAL.equals((Object)t.getMode())) {
                return label == null || label.matches(t.getLabels());
            }
            return label != null && label.matches(t.getLabels());
        }).collect(Collectors.toList());
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public List<HetznerServerTemplate> getServerTemplates() {
        return this.serverTemplates;
    }

    public HetznerCloudResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        @NonNull
        public String getDisplayName() {
            return Messages.plugin_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doVerifyConfiguration(@QueryParameter String credentialsId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ConfigurationValidator.ValidationResult result = ConfigurationValidator.validateCloudConfig(credentialsId);
            if (result.isSuccess()) {
                return FormValidation.ok((String)Messages.cloudConfigPassed());
            }
            return FormValidation.error((String)result.getMessage());
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckCloudName(@QueryParameter String name) {
            if (Helper.isValidLabelValue(name)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Cloud name is not a valid label value: %s", (Object[])new Object[]{name});
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (owner == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !owner.hasPermission(Item.EXTENDED_READ) && !owner.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result;
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, owner, StringCredentialsImpl.class, Collections.emptyList(), CredentialsMatchers.always());
        }
    }
}

