/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.jenkins.plugins.hetzner.HetznerServerAgent;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.trilead.ssh2.crypto.PEMDecoder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.slf4j.Logger;
import org.springframework.security.core.Authentication;
import retrofit2.Response;

public final class Helper {
    private static final Pattern LABEL_VALUE_RE = Pattern.compile("^(?![0-9]+$)(?!-)[a-zA-Z0-9-_.]{0,63}(?<!-)$");
    private static final String SSH_RSA = "ssh-rsa";
    private static final String SSH_ED25519 = "ssh-ed25519";

    public static String getSSHPublicKeyFromPrivate(String privateKey, @Nullable String password) throws IOException {
        Ed25519PublicKeyParameters keyParam;
        String prefix;
        KeyPair pair = PEMDecoder.decodeKeyPair((char[])privateKey.toCharArray(), (String)password);
        PublicKey pk = pair.getPublic();
        if (pk instanceof EdDSAPublicKey) {
            EdDSAPublicKey edpk = (EdDSAPublicKey)pk;
            prefix = SSH_ED25519;
            keyParam = new Ed25519PublicKeyParameters(edpk.getAbyte(), 0);
        } else if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapk = (RSAPublicKey)pk;
            prefix = SSH_RSA;
            keyParam = new RSAKeyParameters(false, rsapk.getModulus(), rsapk.getPublicExponent());
        } else {
            throw new IllegalArgumentException("PublicKey type not recognized: " + String.valueOf(pk.getClass()));
        }
        return prefix + " " + Base64.getEncoder().encodeToString(OpenSSHPublicKeyUtil.encodePublicKey((AsymmetricKeyParameter)keyParam));
    }

    public static boolean isLabelExpression(String expression) {
        return expression.contains("=");
    }

    public static boolean isPossiblyLong(String str) {
        try {
            long value = Long.parseLong(str);
            return value > 0L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static List<Long> idList(String str) {
        return Arrays.stream(str.split(",")).map(Long::parseLong).toList();
    }

    public static <T, E> List<E> getPayload(@NonNull Response<T> response, @NonNull Function<T, List<E>> mapper) {
        Object body = response.body();
        if (body == null) {
            return Collections.emptyList();
        }
        return Optional.ofNullable(mapper.apply(body)).orElse(Collections.emptyList());
    }

    public static <T, E> E assertValidResponse(Response<T> response, Function<T, E> mapper) {
        Preconditions.checkState((boolean)response.isSuccessful(), (String)"Invalid API response : %s", (int)response.code());
        return mapper.apply(response.body());
    }

    public static <T> void assertValidResponse(Response<T> response) {
        Helper.assertValidResponse(response, t -> null);
    }

    public static BasicSSHUserPrivateKey assertSshKey(String credentialsId) {
        BasicSSHUserPrivateKey privateKey = (BasicSSHUserPrivateKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(BasicSSHUserPrivateKey.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        Preconditions.checkState((privateKey != null ? 1 : 0) != 0, (String)"No SSH credentials found with ID '%s'", (Object)credentialsId);
        return privateKey;
    }

    public static String getStringOrDefault(String value, String defValue) {
        if (Strings.isNullOrEmpty((String)value)) {
            return defValue;
        }
        return value;
    }

    public static boolean canShutdownServer(@NonNull String createdStr, LocalDateTime currentTime) {
        LocalDateTime created = LocalDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(createdStr)).atOffset(ZoneOffset.UTC).toLocalDateTime();
        long diff = Duration.between(created, currentTime.atOffset(ZoneOffset.UTC).toLocalDateTime()).toMinutes() % 60L;
        return 55L <= diff;
    }

    public static List<HetznerServerAgent> getHetznerAgents() {
        return Jenkins.get().getNodes().stream().filter(HetznerServerAgent.class::isInstance).map(HetznerServerAgent.class::cast).collect(Collectors.toList());
    }

    public static boolean isValidLabelValue(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return false;
        }
        return LABEL_VALUE_RE.matcher(value).matches();
    }

    private Helper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class LogAdapter {
        private static final SimpleFormatter FORMATTER = new SimpleFormatter();
        private final PrintStream stream;
        private final Logger logger;

        public void info(String message) {
            this.logger.info(message);
            LogRecord rec = new LogRecord(Level.INFO, message);
            rec.setLoggerName(this.logger.getName());
            this.stream.println(FORMATTER.format(rec));
        }

        public void error(String message, Throwable cause) {
            this.logger.error(message, cause);
            LogRecord rec = new LogRecord(Level.SEVERE, message + " Cause: " + String.valueOf(cause));
            rec.setLoggerName(this.logger.getName());
            rec.setThrown(cause);
            this.stream.println(FORMATTER.format(rec));
        }

        public LogAdapter(PrintStream stream, Logger logger) {
            this.stream = stream;
            this.logger = logger;
        }

        public PrintStream getStream() {
            return this.stream;
        }
    }
}

