/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.jenkins.plugins.hetzner.Helper;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerAgent;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerComputer;
import cloud.dnation.jenkins.plugins.hetzner.OrphanedNodesCleaner;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.Arrays;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ControllerListener
extends ComputerListener {
    private static final Logger log = LoggerFactory.getLogger(ControllerListener.class);

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        if (c.getName().isEmpty()) {
            OrphanedNodesCleaner.doCleanup();
        }
        super.onOnline(c, listener);
    }

    public void onOffline(@NonNull Computer c, OfflineCause cause) {
        if (c.getName().isEmpty()) {
            Helper.getHetznerAgents().forEach(this::terminateAgent);
            Arrays.stream(Jenkins.get().getComputers()).filter(HetznerServerComputer.class::isInstance).forEach(this::deleteComputer);
        }
        super.onOffline(c, cause);
    }

    private void deleteComputer(Computer computer) {
        try {
            log.info("Deleting computer {}", (Object)computer);
            computer.doDoDelete();
        }
        catch (IOException e) {
            log.error("Failed to delete computer", (Throwable)e);
        }
    }

    private void terminateAgent(HetznerServerAgent agent) {
        try {
            log.info("Terminating Hetzner agent {}", (Object)agent.getDisplayName());
            agent.terminate();
        }
        catch (Exception e) {
            log.error("Failed to terminate agent", (Throwable)e);
        }
    }
}

