/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.hetznerclient.ClientFactory;
import cloud.dnation.hetznerclient.DatacenterDetail;
import cloud.dnation.hetznerclient.FirewallDetail;
import cloud.dnation.hetznerclient.GetDatacentersResponse;
import cloud.dnation.hetznerclient.GetFirewallByIdResponse;
import cloud.dnation.hetznerclient.GetFirewallsBySelectorResponse;
import cloud.dnation.hetznerclient.GetImageByIdResponse;
import cloud.dnation.hetznerclient.GetImagesBySelectorResponse;
import cloud.dnation.hetznerclient.GetLocationsResponse;
import cloud.dnation.hetznerclient.GetNetworkByIdResponse;
import cloud.dnation.hetznerclient.GetNetworksBySelectorResponse;
import cloud.dnation.hetznerclient.GetPlacementGroupByIdResponse;
import cloud.dnation.hetznerclient.GetPlacementGroupsResponse;
import cloud.dnation.hetznerclient.GetServerTypesResponse;
import cloud.dnation.hetznerclient.GetVolumeByIdResponse;
import cloud.dnation.hetznerclient.HetznerApi;
import cloud.dnation.hetznerclient.ImageDetail;
import cloud.dnation.hetznerclient.LocationDetail;
import cloud.dnation.hetznerclient.NetworkDetail;
import cloud.dnation.hetznerclient.PlacementGroupDetail;
import cloud.dnation.hetznerclient.ServerType;
import cloud.dnation.jenkins.plugins.hetzner.Helper;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerTemplate;
import cloud.dnation.jenkins.plugins.hetzner.JenkinsSecretTokenProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationValidator {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationValidator.class);

    static ValidationResult validateCloudConfig(String credentialsId) {
        return ConfigurationValidator.validateWithClient(api -> {
            GetDatacentersResponse result = (GetDatacentersResponse)api.getAllDatacenters().execute().body();
            Preconditions.checkArgument((!result.getDatacenters().isEmpty() ? 1 : 0) != 0, (Object)"Expected some data");
            return ValidationResult.OK;
        }, credentialsId);
    }

    private static ValidationResult validateWithClient(ValidationAction action, String credentialsId) {
        HetznerApi client = ClientFactory.create((Supplier)JenkinsSecretTokenProvider.forCredentialsId(credentialsId));
        try {
            return action.validate(client);
        }
        catch (Exception e) {
            return ValidationResult.fromException(e);
        }
    }

    static ValidationResult validateDatacenter(String datacenter, String credentialsId) {
        if (Strings.isNullOrEmpty((String)datacenter)) {
            return new ValidationResult(false, "Datacenter is empty");
        }
        return ConfigurationValidator.validateWithClient(api -> {
            GetDatacentersResponse result = (GetDatacentersResponse)api.getAllDatacentersWithName(datacenter).execute().body();
            Preconditions.checkArgument((result.getDatacenters().size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one result, got %s", (int)result.getDatacenters().size());
            return new ValidationResult(true, "Found: " + ((DatacenterDetail)result.getDatacenters().get(0)).getDescription());
        }, credentialsId);
    }

    static ValidationResult verifyImage(String image, String credentialsId) {
        if (Strings.isNullOrEmpty((String)image)) {
            return new ValidationResult(false, "Image label expression is empty");
        }
        return ConfigurationValidator.validateWithClient(api -> {
            if (Helper.isLabelExpression(image)) {
                GetImagesBySelectorResponse result = (GetImagesBySelectorResponse)api.getImagesBySelector(image).execute().body();
                Preconditions.checkArgument((result.getImages().size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one result, got %s", (int)result.getImages().size());
                return new ValidationResult(true, "Found: " + ((ImageDetail)result.getImages().get(0)).getDescription());
            }
            if (Helper.isPossiblyLong(image)) {
                GetImageByIdResponse result = (GetImageByIdResponse)api.getImageById(Long.valueOf(Long.parseLong(image))).execute().body();
                return new ValidationResult(true, "Found: " + result.getImage().getDescription());
            }
            return new ValidationResult(false, "Image expression unsupported : " + image);
        }, credentialsId);
    }

    static ValidationResult verifyNetwork(String network, String credentialsId) {
        if (Strings.isNullOrEmpty((String)network)) {
            return new ValidationResult(false, "Network label expression is empty");
        }
        return ConfigurationValidator.validateWithClient(api -> {
            if (Helper.isLabelExpression(network)) {
                GetNetworksBySelectorResponse result = (GetNetworksBySelectorResponse)api.getNetworkBySelector(network).execute().body();
                Preconditions.checkArgument((result.getNetworks().size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one result, got %s", (int)result.getNetworks().size());
                return new ValidationResult(true, "Found: " + ((NetworkDetail)result.getNetworks().get(0)).getName() + " " + ((NetworkDetail)result.getNetworks().get(0)).getIpRange());
            }
            if (Helper.isPossiblyLong(network)) {
                GetNetworkByIdResponse result = (GetNetworkByIdResponse)api.getNetworkById(Long.parseLong(network)).execute().body();
                return new ValidationResult(true, "Found: " + result.getNetwork().getName() + " " + result.getNetwork().getIpRange());
            }
            return new ValidationResult(false, "Network expression unsupported : " + network);
        }, credentialsId);
    }

    static ValidationResult verifyFirewall(String firewall, String credentialsId) {
        if (Strings.isNullOrEmpty((String)firewall)) {
            return new ValidationResult(false, "Firewall label expression is empty");
        }
        return ConfigurationValidator.validateWithClient(api -> {
            if (Helper.isLabelExpression(firewall)) {
                GetFirewallsBySelectorResponse result = (GetFirewallsBySelectorResponse)api.getFirewallsBySelector(firewall).execute().body();
                Preconditions.checkArgument((result.getFirewalls().size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one result, got %s", (int)result.getFirewalls().size());
                return new ValidationResult(true, "Found: " + ((FirewallDetail)result.getFirewalls().get(0)).getName());
            }
            if (Helper.isPossiblyLong(firewall)) {
                GetFirewallByIdResponse result = (GetFirewallByIdResponse)api.getFirewallById(Long.parseLong(firewall)).execute().body();
                return new ValidationResult(true, "Found: " + result.getFirewall().getName());
            }
            return new ValidationResult(false, "Firewall expression unsupported : " + firewall);
        }, credentialsId);
    }

    static ValidationResult verifyPlacementGroup(String placementGroup, String credentialsId) {
        if (Strings.isNullOrEmpty((String)placementGroup)) {
            return new ValidationResult(false, "Placement group expression is empty");
        }
        return ConfigurationValidator.validateWithClient(api -> {
            if (Helper.isLabelExpression(placementGroup)) {
                GetPlacementGroupsResponse result = (GetPlacementGroupsResponse)api.getPlacementGroups(placementGroup).execute().body();
                Preconditions.checkArgument((result.getPlacementGroups().size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one result, got %s", (int)result.getPlacementGroups().size());
                return new ValidationResult(true, "Found: " + ((PlacementGroupDetail)result.getPlacementGroups().get(0)).getName() + " " + ((PlacementGroupDetail)result.getPlacementGroups().get(0)).getId());
            }
            if (Helper.isPossiblyLong(placementGroup)) {
                GetPlacementGroupByIdResponse result = (GetPlacementGroupByIdResponse)api.getPlacementGroupById(Long.parseLong(placementGroup)).execute().body();
                return new ValidationResult(true, "Found: " + result.getPlacementGroup().getName() + " " + result.getPlacementGroup().getId());
            }
            return new ValidationResult(false, "Placement group expression unsupported : " + placementGroup);
        }, credentialsId);
    }

    static ValidationResult verifyServerType(String serverType, String credentialsId) {
        if (Strings.isNullOrEmpty((String)serverType)) {
            return new ValidationResult(false, "Server type is empty");
        }
        return ConfigurationValidator.validateWithClient(api -> {
            GetServerTypesResponse result = (GetServerTypesResponse)api.getAllServerTypesWithName(serverType).execute().body();
            Preconditions.checkArgument((result.getServerTypes().size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one result, got {}", (int)result.getServerTypes().size());
            return new ValidationResult(true, "Found: " + ((ServerType)result.getServerTypes().get(0)).getDescription());
        }, credentialsId);
    }

    static ValidationResult verifyLocation(String location, String credentialsId) {
        if (Strings.isNullOrEmpty((String)location)) {
            return new ValidationResult(false, "Location is empty");
        }
        if (location.contains("-")) {
            return ConfigurationValidator.validateDatacenter(location, credentialsId);
        }
        return ConfigurationValidator.validateWithClient(api -> {
            GetLocationsResponse result = (GetLocationsResponse)api.getAllLocationsWithName(location).execute().body();
            Preconditions.checkArgument((result.getLocations().size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one result, got {}", (int)result.getLocations().size());
            return new ValidationResult(true, "Found: " + ((LocationDetail)result.getLocations().get(0)).getDescription());
        }, credentialsId);
    }

    static ValidationResult verifyVolume(String volume, String credentialsId) {
        return ConfigurationValidator.validateWithClient(api -> {
            if (!Helper.isPossiblyLong(volume)) {
                return new ValidationResult(false, String.format("not a valid volume ID: %s", volume));
            }
            GetVolumeByIdResponse result = (GetVolumeByIdResponse)api.getVolumeById(Long.parseLong(volume)).execute().body();
            if (result == null) {
                return new ValidationResult(false, String.format("Volume %s not found", volume));
            }
            return new ValidationResult(true, String.format("%s: %s", result.getVolume().getName(), result.getVolume().getFormat()));
        }, credentialsId);
    }

    static ValidationResult verifyVolumes(String volumeIds, String credentialId) {
        log.info("volumeIds: {}", (Object)volumeIds);
        return Arrays.stream(volumeIds.split(",")).map(volId -> ConfigurationValidator.verifyVolume(volId, credentialId)).filter(res -> !res.isSuccess()).findFirst().orElse(ValidationResult.OK);
    }

    public static FormValidation doCheckPositiveInt(String value, String name) {
        if (Ints.tryParse((String)value) == null) {
            return FormValidation.error((String)(name + " must be positive integer : " + value));
        }
        return FormValidation.ok();
    }

    public static FormValidation doCheckNonEmpty(String value, String name) {
        if (Strings.isNullOrEmpty((String)value)) {
            return FormValidation.error((String)(name + " must be specified"));
        }
        return FormValidation.ok();
    }

    public static FormValidation verifyPrefix(String prefix) {
        if (HetznerServerTemplate.checkPrefixValue(prefix)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)("Invalid prefix: " + prefix));
    }

    private static interface ValidationAction {
        public ValidationResult validate(HetznerApi var1) throws Exception;
    }

    static class ValidationResult {
        static final ValidationResult OK = new ValidationResult(true, "OK");
        private final boolean success;
        private final String message;

        static ValidationResult fromException(Throwable e) {
            log.warn("API invocation failed", e);
            return new ValidationResult(false, Throwables.getRootCause((Throwable)e).getMessage());
        }

        FormValidation toFormValidation() {
            if (this.success) {
                return FormValidation.ok((String)this.message);
            }
            return FormValidation.error((String)this.message);
        }

        public ValidationResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidationResult)) {
                return false;
            }
            ValidationResult other = (ValidationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValidationResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigurationValidator.ValidationResult(success=" + this.isSuccess() + ", message=" + this.getMessage() + ")";
        }
    }
}

