// CHECKSTYLE:OFF

package cloud.dnation.jenkins.plugins.hetzner;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code connector.SshAsRoot}: {@code Connect via SSH as root, but
     * launch agent as user configured in credentials}.
     * 
     * @return
     *     {@code Connect via SSH as root, but launch agent as user configured in
     *     credentials}
     */
    public static String connector_SshAsRoot() {
        return holder.format("connector.SshAsRoot");
    }

    /**
     * Key {@code connector.SshAsRoot}: {@code Connect via SSH as root, but
     * launch agent as user configured in credentials}.
     * 
     * @return
     *     {@code Connect via SSH as root, but launch agent as user configured in
     *     credentials}
     */
    public static Localizable _connector_SshAsRoot() {
        return new Localizable(holder, "connector.SshAsRoot");
    }

    /**
     * Key {@code connectivity.private-only}: {@code Only private networking
     * will be used. Network ID or label expression must be provided as
     * well.}.
     * 
     * @return
     *     {@code Only private networking will be used. Network ID or label
     *     expression must be provided as well.}
     */
    public static String connectivity_private_only() {
        return holder.format("connectivity.private-only");
    }

    /**
     * Key {@code connectivity.private-only}: {@code Only private networking
     * will be used. Network ID or label expression must be provided as
     * well.}.
     * 
     * @return
     *     {@code Only private networking will be used. Network ID or label
     *     expression must be provided as well.}
     */
    public static Localizable _connectivity_private_only() {
        return new Localizable(holder, "connectivity.private-only");
    }

    /**
     * Key {@code connection.method.publicV6}: {@code Connect using public
     * IPv6 address only}.
     * 
     * @return
     *     {@code Connect using public IPv6 address only}
     */
    public static String connection_method_publicV6() {
        return holder.format("connection.method.publicV6");
    }

    /**
     * Key {@code connection.method.publicV6}: {@code Connect using public
     * IPv6 address only}.
     * 
     * @return
     *     {@code Connect using public IPv6 address only}
     */
    public static Localizable _connection_method_publicV6() {
        return new Localizable(holder, "connection.method.publicV6");
    }

    /**
     * Key {@code connection.method.public}: {@code Connect using public IPv4
     * address only}.
     * 
     * @return
     *     {@code Connect using public IPv4 address only}
     */
    public static String connection_method_public() {
        return holder.format("connection.method.public");
    }

    /**
     * Key {@code connection.method.public}: {@code Connect using public IPv4
     * address only}.
     * 
     * @return
     *     {@code Connect using public IPv4 address only}
     */
    public static Localizable _connection_method_public() {
        return new Localizable(holder, "connection.method.public");
    }

    /**
     * Key {@code connection.method.default}: {@code Connect using private
     * IPv4 address if available, otherwise using public IPv4 address}.
     * 
     * @return
     *     {@code Connect using private IPv4 address if available, otherwise
     *     using public IPv4 address}
     */
    public static String connection_method_default() {
        return holder.format("connection.method.default");
    }

    /**
     * Key {@code connection.method.default}: {@code Connect using private
     * IPv4 address if available, otherwise using public IPv4 address}.
     * 
     * @return
     *     {@code Connect using private IPv4 address if available, otherwise
     *     using public IPv4 address}
     */
    public static Localizable _connection_method_default() {
        return new Localizable(holder, "connection.method.default");
    }

    /**
     * Key {@code connectivity.public-only}: {@code Only public networking
     * will be allocated}.
     * 
     * @return
     *     {@code Only public networking will be allocated}
     */
    public static String connectivity_public_only() {
        return holder.format("connectivity.public-only");
    }

    /**
     * Key {@code connectivity.public-only}: {@code Only public networking
     * will be allocated}.
     * 
     * @return
     *     {@code Only public networking will be allocated}
     */
    public static Localizable _connectivity_public_only() {
        return new Localizable(holder, "connectivity.public-only");
    }

    /**
     * Key {@code primaryip.bylabelselector.failing}: {@code Allocate primary
     * IPv4 using label selector, fail if none is available}.
     * 
     * @return
     *     {@code Allocate primary IPv4 using label selector, fail if none is
     *     available}
     */
    public static String primaryip_bylabelselector_failing() {
        return holder.format("primaryip.bylabelselector.failing");
    }

    /**
     * Key {@code primaryip.bylabelselector.failing}: {@code Allocate primary
     * IPv4 using label selector, fail if none is available}.
     * 
     * @return
     *     {@code Allocate primary IPv4 using label selector, fail if none is
     *     available}
     */
    public static Localizable _primaryip_bylabelselector_failing() {
        return new Localizable(holder, "primaryip.bylabelselector.failing");
    }

    /**
     * Key {@code connectivity.both}: {@code Configure both private and
     * public networking. Additional constrains may apply}.
     * 
     * @return
     *     {@code Configure both private and public networking. Additional
     *     constrains may apply}
     */
    public static String connectivity_both() {
        return holder.format("connectivity.both");
    }

    /**
     * Key {@code connectivity.both}: {@code Configure both private and
     * public networking. Additional constrains may apply}.
     * 
     * @return
     *     {@code Configure both private and public networking. Additional
     *     constrains may apply}
     */
    public static Localizable _connectivity_both() {
        return new Localizable(holder, "connectivity.both");
    }

    /**
     * Key {@code serverTemplate.displayName}: {@code Hetzner server
     * template}.
     * 
     * @return
     *     {@code Hetzner server template}
     */
    public static String serverTemplate_displayName() {
        return holder.format("serverTemplate.displayName");
    }

    /**
     * Key {@code serverTemplate.displayName}: {@code Hetzner server
     * template}.
     * 
     * @return
     *     {@code Hetzner server template}
     */
    public static Localizable _serverTemplate_displayName() {
        return new Localizable(holder, "serverTemplate.displayName");
    }

    /**
     * Key {@code connectivity.publicV6-only}: {@code Only public IPv6
     * networking will be allocated}.
     * 
     * @return
     *     {@code Only public IPv6 networking will be allocated}
     */
    public static String connectivity_publicV6_only() {
        return holder.format("connectivity.publicV6-only");
    }

    /**
     * Key {@code connectivity.publicV6-only}: {@code Only public IPv6
     * networking will be allocated}.
     * 
     * @return
     *     {@code Only public IPv6 networking will be allocated}
     */
    public static Localizable _connectivity_publicV6_only() {
        return new Localizable(holder, "connectivity.publicV6-only");
    }

    /**
     * Key {@code policy.shutdown.beforeHourWrap}: {@code Removes idle server
     * just before current hour of billing cycle completes}.
     * 
     * @return
     *     {@code Removes idle server just before current hour of billing cycle
     *     completes}
     */
    public static String policy_shutdown_beforeHourWrap() {
        return holder.format("policy.shutdown.beforeHourWrap");
    }

    /**
     * Key {@code policy.shutdown.beforeHourWrap}: {@code Removes idle server
     * just before current hour of billing cycle completes}.
     * 
     * @return
     *     {@code Removes idle server just before current hour of billing cycle
     *     completes}
     */
    public static Localizable _policy_shutdown_beforeHourWrap() {
        return new Localizable(holder, "policy.shutdown.beforeHourWrap");
    }

    /**
     * Key {@code policy.shutdown.idle}: {@code Removes server after it's
     * idle for period of time}.
     * 
     * @return
     *     {@code Removes server after it's idle for period of time}
     */
    public static String policy_shutdown_idle() {
        return holder.format("policy.shutdown.idle");
    }

    /**
     * Key {@code policy.shutdown.idle}: {@code Removes server after it's
     * idle for period of time}.
     * 
     * @return
     *     {@code Removes server after it's idle for period of time}
     */
    public static Localizable _policy_shutdown_idle() {
        return new Localizable(holder, "policy.shutdown.idle");
    }

    /**
     * Key {@code primaryip.bylabelselector.ignoring}: {@code Allocate
     * primary IPv4 using label selector, ignore any error}.
     * 
     * @return
     *     {@code Allocate primary IPv4 using label selector, ignore any error}
     */
    public static String primaryip_bylabelselector_ignoring() {
        return holder.format("primaryip.bylabelselector.ignoring");
    }

    /**
     * Key {@code primaryip.bylabelselector.ignoring}: {@code Allocate
     * primary IPv4 using label selector, ignore any error}.
     * 
     * @return
     *     {@code Allocate primary IPv4 using label selector, ignore any error}
     */
    public static Localizable _primaryip_bylabelselector_ignoring() {
        return new Localizable(holder, "primaryip.bylabelselector.ignoring");
    }

    /**
     * Key {@code plugin.description}: {@code Plugin for launching build
     * Agents as Hetzner compute resources}.
     * 
     * @return
     *     {@code Plugin for launching build Agents as Hetzner compute resources}
     */
    public static String plugin_description() {
        return holder.format("plugin.description");
    }

    /**
     * Key {@code plugin.description}: {@code Plugin for launching build
     * Agents as Hetzner compute resources}.
     * 
     * @return
     *     {@code Plugin for launching build Agents as Hetzner compute resources}
     */
    public static Localizable _plugin_description() {
        return new Localizable(holder, "plugin.description");
    }

    /**
     * Key {@code cloudConfigPassed}: {@code Cloud configuration seems to be
     * valid}.
     * 
     * @return
     *     {@code Cloud configuration seems to be valid}
     */
    public static String cloudConfigPassed() {
        return holder.format("cloudConfigPassed");
    }

    /**
     * Key {@code cloudConfigPassed}: {@code Cloud configuration seems to be
     * valid}.
     * 
     * @return
     *     {@code Cloud configuration seems to be valid}
     */
    public static Localizable _cloudConfigPassed() {
        return new Localizable(holder, "cloudConfigPassed");
    }

    /**
     * Key {@code plugin.displayName}: {@code Hetzner}.
     * 
     * @return
     *     {@code Hetzner}
     */
    public static String plugin_displayName() {
        return holder.format("plugin.displayName");
    }

    /**
     * Key {@code plugin.displayName}: {@code Hetzner}.
     * 
     * @return
     *     {@code Hetzner}
     */
    public static Localizable _plugin_displayName() {
        return new Localizable(holder, "plugin.displayName");
    }

    /**
     * Key {@code primaryip.default}: {@code Use default behavior}.
     * 
     * @return
     *     {@code Use default behavior}
     */
    public static String primaryip_default() {
        return holder.format("primaryip.default");
    }

    /**
     * Key {@code primaryip.default}: {@code Use default behavior}.
     * 
     * @return
     *     {@code Use default behavior}
     */
    public static Localizable _primaryip_default() {
        return new Localizable(holder, "primaryip.default");
    }

    /**
     * Key {@code connector.SshAsNonRoot}: {@code Connect via SSH as user
     * configured in credentials}.
     * 
     * @return
     *     {@code Connect via SSH as user configured in credentials}
     */
    public static String connector_SshAsNonRoot() {
        return holder.format("connector.SshAsNonRoot");
    }

    /**
     * Key {@code connector.SshAsNonRoot}: {@code Connect via SSH as user
     * configured in credentials}.
     * 
     * @return
     *     {@code Connect via SSH as user configured in credentials}
     */
    public static Localizable _connector_SshAsNonRoot() {
        return new Localizable(holder, "connector.SshAsNonRoot");
    }

    /**
     * Key {@code connection.method.defaultV6}: {@code Connect using private
     * IPv4 address if available, otherwise using public IPv6 address}.
     * 
     * @return
     *     {@code Connect using private IPv4 address if available, otherwise
     *     using public IPv6 address}
     */
    public static String connection_method_defaultV6() {
        return holder.format("connection.method.defaultV6");
    }

    /**
     * Key {@code connection.method.defaultV6}: {@code Connect using private
     * IPv4 address if available, otherwise using public IPv6 address}.
     * 
     * @return
     *     {@code Connect using private IPv4 address if available, otherwise
     *     using public IPv6 address}
     */
    public static Localizable _connection_method_defaultV6() {
        return new Localizable(holder, "connection.method.defaultV6");
    }

    /**
     * Key {@code connectivity.bothV6}: {@code Configure both private network
     * and public IPv6. Additional constrains may apply}.
     * 
     * @return
     *     {@code Configure both private network and public IPv6. Additional
     *     constrains may apply}
     */
    public static String connectivity_bothV6() {
        return holder.format("connectivity.bothV6");
    }

    /**
     * Key {@code connectivity.bothV6}: {@code Configure both private network
     * and public IPv6. Additional constrains may apply}.
     * 
     * @return
     *     {@code Configure both private network and public IPv6. Additional
     *     constrains may apply}
     */
    public static Localizable _connectivity_bothV6() {
        return new Localizable(holder, "connectivity.bothV6");
    }

}
