/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gparams;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import io.jenkins.plugins.gparams.Parameters;
import io.jenkins.plugins.gparams.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class GParamsWriteStep
extends Step {
    private final String name;
    private final String value;

    @DataBoundConstructor
    public GParamsWriteStep(String name, String value) {
        if (!Utils.isValidParameterName(name)) {
            throw new IllegalArgumentException("The '" + name + "' is not a valid gparams variable name");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    private static class Execution
    extends SynchronousStepExecution<Void> {
        private final transient GParamsWriteStep step;
        private static final long serialVersionUID = 1L;

        public Execution(GParamsWriteStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            String name = this.step.getName();
            String value = this.step.getValue();
            if (!Utils.isValidParameterName(name)) {
                throw new IllegalArgumentException("The '" + name + "' is not a valid gparams variable name");
            }
            PrintStream logger = Objects.requireNonNull((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
            String filePath = Parameters.GParamDirectoryName + name;
            File file = new File(filePath);
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("Create directory " + parent.getAbsolutePath() + " error.");
            }
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Create file " + file.getAbsolutePath() + " error");
            }
            logger.println("Create file " + file.getAbsolutePath());
            try (FileOutputStream out = new FileOutputStream(file);
                 FileLock lock = out.getChannel().lock();){
                out.write(value.getBytes(StandardCharsets.UTF_8));
            }
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "gpWrite";
        }

        @NonNull
        public String getDisplayName() {
            return "Write global parameter";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

