/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabcredentialsk8s;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import io.fabric8.kubernetes.api.model.Secret;
import io.jenkins.plugins.gitlabserverconfig.credentials.GroupAccessTokenImpl;
import io.jenkins.plugins.gitlabserverconfig.credentials.PersonalAccessTokenImpl;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class GitLabCredentialConverter
extends SecretToCredentialConverter {
    private static final Logger LOG = Logger.getLogger(GitLabCredentialConverter.class.getName());

    public boolean canConvert(String type) {
        return "gitlabToken".equals(type) || "gitlabGroupToken".equals(type);
    }

    public StandardUsernamePasswordCredentials convert(Secret secret) throws CredentialsConvertionException {
        String bearerTokenBase64 = SecretUtils.getNonNullSecretData((Secret)secret, (String)"text", (String)"gitlabToken/gitlabGroupToken credential is missing the token (in the text property)");
        String bearerToken = (String)SecretUtils.requireNonNull((Object)GitLabCredentialConverter.base64DecodeToString(bearerTokenBase64), (String)"gitlabToken/gitlabGroupToken credential has an invalid token (the data in the text property must be base64 encoded UTF-8)");
        String type = (String)secret.getMetadata().getLabels().get("jenkins.io/credentials-type");
        if ("gitlabGroupToken".equals(type)) {
            GroupAccessTokenImpl credentials = new GroupAccessTokenImpl(CredentialsScope.GLOBAL, SecretUtils.getCredentialId((Secret)secret), SecretUtils.getCredentialDescription((Secret)secret));
            credentials.setToken(bearerToken);
            return credentials;
        }
        if ("gitlabToken".equals(type)) {
            PersonalAccessTokenImpl credentials = new PersonalAccessTokenImpl(CredentialsScope.GLOBAL, SecretUtils.getCredentialId((Secret)secret), SecretUtils.getCredentialDescription((Secret)secret));
            credentials.setToken(bearerToken);
            return credentials;
        }
        throw new CredentialsConvertionException("Unsupported credentials type: " + type + " for secret ID: " + SecretUtils.getCredentialId((Secret)secret));
    }

    @CheckForNull
    private static byte[] base64Decode(String s) {
        try {
            return Base64.getDecoder().decode(s);
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.WARNING, "failed to base64decode Secret, is the format valid?  {0}", ex.getMessage());
            return null;
        }
    }

    @CheckForNull
    public static String base64DecodeToString(String s) {
        byte[] bytes = GitLabCredentialConverter.base64Decode(s);
        if (bytes != null) {
            try {
                CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                CharBuffer decode = decoder.decode(ByteBuffer.wrap(bytes));
                return decode.toString();
            }
            catch (CharacterCodingException ex) {
                LOG.log(Level.WARNING, "failed to covert Secret, is this a valid UTF-8 string?  {0}", ex.getMessage());
            }
        }
        return null;
    }
}

