/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github.status;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.model.Job;
import hudson.plugins.git.GitSCM;
import io.jenkins.plugins.checks.github.SCMFacade;
import io.jenkins.plugins.checks.github.status.DefaultGitHubStatusChecksConfigurations;
import io.jenkins.plugins.checks.github.status.GitHubStatusChecksConfigurations;
import io.jenkins.plugins.checks.status.AbstractStatusChecksProperties;
import java.util.Optional;
import java.util.stream.Stream;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

@Extension
public class GitHubStatusChecksProperties
extends AbstractStatusChecksProperties {
    private static final GitHubStatusChecksConfigurations DEFAULT_CONFIGURATION = new DefaultGitHubStatusChecksConfigurations();
    private final SCMFacade scmFacade;

    public GitHubStatusChecksProperties() {
        this(new SCMFacade());
    }

    @VisibleForTesting
    GitHubStatusChecksProperties(SCMFacade facade) {
        this.scmFacade = facade;
    }

    public boolean isApplicable(Job<?, ?> job) {
        return this.scmFacade.findGitHubSCMSource(job).isPresent() || this.scmFacade.findGitSCM(job).isPresent();
    }

    public String getName(Job<?, ?> job) {
        return this.getConfigurations(job).orElse(DEFAULT_CONFIGURATION).getName();
    }

    public boolean isSkipped(Job<?, ?> job) {
        return this.getConfigurations(job).orElse(DEFAULT_CONFIGURATION).isSkip();
    }

    public boolean isUnstableBuildNeutral(Job<?, ?> job) {
        return this.getConfigurations(job).orElse(DEFAULT_CONFIGURATION).isUnstableBuildNeutral();
    }

    public boolean isSuppressLogs(Job<?, ?> job) {
        return this.getConfigurations(job).orElse(DEFAULT_CONFIGURATION).isSuppressLogs();
    }

    public boolean isSkipProgressUpdates(Job<?, ?> job) {
        return this.getConfigurations(job).orElse(DEFAULT_CONFIGURATION).isSkipProgressUpdates();
    }

    private Optional<GitHubStatusChecksConfigurations> getConfigurations(Job<?, ?> job) {
        Optional<GitHubSCMSource> gitHubSCMSource = this.scmFacade.findGitHubSCMSource(job);
        if (gitHubSCMSource.isPresent()) {
            return this.getConfigurations(gitHubSCMSource.get().getTraits().stream());
        }
        Optional<GitSCM> gitSCM = this.scmFacade.findGitSCM(job);
        if (gitSCM.isPresent()) {
            return this.getConfigurations(gitSCM.get().getExtensions().stream());
        }
        return Optional.empty();
    }

    private Optional<GitHubStatusChecksConfigurations> getConfigurations(Stream<?> stream) {
        return stream.filter(t -> t instanceof GitHubStatusChecksConfigurations).findFirst().map(t -> (GitHubStatusChecksConfigurations)t);
    }
}

