/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.jenkins.plugins.checks.github.SCMFacade;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.springframework.security.core.Authentication;

@Extension
public class CheckRunGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = Logger.getLogger(CheckRunGHEventSubscriber.class.getName());
    private static final String RERUN_ACTION = "rerequested";
    private final JenkinsFacade jenkinsFacade;
    private final SCMFacade scmFacade;

    public CheckRunGHEventSubscriber() {
        this(new JenkinsFacade(), new SCMFacade());
    }

    @VisibleForTesting
    CheckRunGHEventSubscriber(JenkinsFacade jenkinsFacade, SCMFacade scmFacade) {
        this.jenkinsFacade = jenkinsFacade;
        this.scmFacade = scmFacade;
    }

    protected boolean isApplicable(@CheckForNull Item item) {
        if (item instanceof Job) {
            return this.scmFacade.findGitHubSCMSource((Job)item).isPresent();
        }
        return false;
    }

    protected Set<GHEvent> events() {
        return Set.copyOf(Collections.singletonList(GHEvent.CHECK_RUN));
    }

    protected void onEvent(GHSubscriberEvent event) {
        String payload = (String)event.getPayload();
        try {
            GHEventPayload.CheckRun checkRun = (GHEventPayload.CheckRun)GitHub.offline().parseEventPayload((Reader)new StringReader(payload), GHEventPayload.CheckRun.class);
            if (!RERUN_ACTION.equals(checkRun.getAction())) {
                LOGGER.log(Level.FINE, "Unsupported check run action: " + checkRun.getAction().replaceAll("[\r\n]", ""));
                return;
            }
            JSONObject payloadJSON = new JSONObject(payload);
            LOGGER.log(Level.INFO, "Received rerun request through GitHub checks API.");
            try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
                String branchName = payloadJSON.getJSONObject("check_run").getJSONObject("check_suite").optString("head_branch");
                this.scheduleRerun(checkRun, branchName);
            }
        }
        catch (IOException | JSONException e) {
            throw new IllegalStateException("Could not parse check run event: " + payload.replaceAll("[\r\n]", ""), e);
        }
    }

    private void scheduleRerun(GHEventPayload.CheckRun checkRun, String branchName) {
        GHRepository repository = checkRun.getRepository();
        Optional optionalRun = this.jenkinsFacade.getBuild(checkRun.getCheckRun().getExternalId());
        if (optionalRun.isPresent()) {
            Run run = (Run)optionalRun.get();
            Job job = run.getParent();
            GitHubChecksRerunActionCause cause = new GitHubChecksRerunActionCause(checkRun.getSender().getLogin(), branchName);
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(new CauseAction((Cause)cause));
            ParametersAction paramAction = (ParametersAction)run.getAction(ParametersAction.class);
            if (paramAction != null) {
                actions.add(paramAction);
            }
            ParameterizedJobMixIn.scheduleBuild2((Job)job, (int)0, (Action[])actions.toArray(new Action[0]));
            LOGGER.log(Level.INFO, String.format("Scheduled rerun (build #%d) for job %s, requested by %s", job.getNextBuildNumber(), this.jenkinsFacade.getFullNameOf(job), checkRun.getSender().getLogin()).replaceAll("[\r\n]", ""));
        } else {
            LOGGER.log(Level.WARNING, String.format("No build found for rerun request from repository: %s and id: %s", repository.getFullName(), checkRun.getCheckRun().getExternalId()).replaceAll("[\r\n]", ""));
        }
    }

    public static class GitHubChecksRerunActionCause
    extends Cause {
        private final String user;
        private final String branchName;

        public GitHubChecksRerunActionCause(String user, String branchName) {
            this.user = user;
            this.branchName = branchName;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public String getShortDescription() {
            return String.format("Rerun request by %s through GitHub checks API, for branch %s", this.user, this.branchName);
        }
    }
}

