/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.util.BuildData;
import io.jenkins.plugins.checks.github.GitHubChecksContext;
import io.jenkins.plugins.checks.github.SCMFacade;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

class GitSCMChecksContext
extends GitHubChecksContext {
    private static final int VALID_REPOSITORY_PATH_SEGMENTS = 2;
    private final Run<?, ?> run;

    GitSCMChecksContext(Run<?, ?> run, String runURL) {
        this(run, runURL, new SCMFacade());
    }

    GitSCMChecksContext(Run<?, ?> run, String runURL, SCMFacade scmFacade) {
        super(run.getParent(), runURL, scmFacade);
        this.run = run;
    }

    @Override
    protected Optional<Run<?, ?>> getRun() {
        return Optional.of(this.run);
    }

    @Override
    public String getHeadSha() {
        try {
            String head = this.getGitCommitEnvironment();
            if (StringUtils.isNotBlank((CharSequence)head)) {
                return head;
            }
            return this.getLastBuiltRevisionFromBuildData();
        }
        catch (IOException | InterruptedException exception) {
            return "";
        }
    }

    public String getGitCommitEnvironment() throws IOException, InterruptedException {
        return StringUtils.defaultString((String)((String)this.run.getEnvironment(TaskListener.NULL).get((Object)"GIT_COMMIT")));
    }

    private String getLastBuiltRevisionFromBuildData() {
        Revision lastBuiltRevision;
        BuildData gitBuildData = (BuildData)this.run.getAction(BuildData.class);
        if (gitBuildData != null && (lastBuiltRevision = gitBuildData.getLastBuiltRevision()) != null) {
            return lastBuiltRevision.getSha1().getName();
        }
        return "";
    }

    @Override
    public String getRepository() {
        String repositoryURL = this.getUserRemoteConfig().getUrl();
        if (repositoryURL == null) {
            return "";
        }
        return this.getRepository(repositoryURL);
    }

    @VisibleForTesting
    String getRepository(String repositoryUrl) {
        if (StringUtils.isBlank((CharSequence)repositoryUrl)) {
            return "";
        }
        if (repositoryUrl.startsWith("http")) {
            URL url;
            try {
                url = new URL(repositoryUrl);
            }
            catch (MalformedURLException e) {
                return "";
            }
            String[] pathParts = StringUtils.removeStart((String)url.getPath(), (String)"/").split("/");
            if (pathParts.length == 2) {
                return pathParts[0] + "/" + StringUtils.removeEnd((String)pathParts[1], (String)".git");
            }
        } else if (repositoryUrl.matches("git@.+:.+\\/.+")) {
            return StringUtils.removeEnd((String)repositoryUrl.split(":")[1], (String)".git");
        }
        return "";
    }

    @Override
    @CheckForNull
    protected String getCredentialsId() {
        return this.getUserRemoteConfig().getCredentialsId();
    }

    private UserRemoteConfig getUserRemoteConfig() {
        return this.getScmFacade().getUserRemoteConfig(this.resolveGitSCM());
    }

    private GitSCM resolveGitSCM() {
        Optional<GitSCM> gitSCM = this.getScmFacade().findGitSCM(this.run);
        if (gitSCM.isPresent()) {
            return gitSCM.get();
        }
        throw new IllegalStateException("Skipped publishing GitHub checks: no Git SCM source available for job: " + this.getJob().getName());
    }

    @Override
    public boolean isValid(FilteredLog logger) {
        logger.logError("Trying to resolve checks parameters from Git SCM...");
        if (this.getScmFacade().findGitSCM(this.run).isEmpty()) {
            logger.logError("Job does not use Git SCM");
            return false;
        }
        if (!this.hasValidCredentials(logger)) {
            logger.logError("Job does not have valid credentials");
            return false;
        }
        String repository = this.getRepository();
        if (StringUtils.isEmpty((CharSequence)repository)) {
            logger.logError("Repository url is not valid, requiring one of the following schemes:\n\t1. \"git@git-server:repository-owner/repository(.git)\"\n\t2. \"http(s)://git-server/repository-owner/repository(.git)\"");
            return false;
        }
        if (this.getHeadSha().isEmpty()) {
            logger.logError("No HEAD SHA found for '%s'", new Object[]{repository});
            return false;
        }
        logger.logInfo("Using GitSCM repository '%s' for GitHub checks", new Object[]{repository});
        return true;
    }
}

