/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.gitea;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.gitea.GiteaChecksContext;
import io.jenkins.plugins.checks.gitea.GiteaChecksDetails;
import io.jenkins.plugins.util.PluginLogger;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import org.jenkinsci.plugin.gitea.client.api.Gitea;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuth;
import org.jenkinsci.plugin.gitea.client.api.GiteaCommitStatus;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;

public class GiteaChecksPublisher
extends ChecksPublisher {
    private static final Logger SYSTEM_LOGGER = Logger.getLogger(GiteaChecksPublisher.class.getName());
    private final GiteaChecksContext context;
    private final PluginLogger buildLogger;
    private final String giteaServerUrl;

    public GiteaChecksPublisher(GiteaChecksContext context, PluginLogger buildLogger) {
        this(context, buildLogger, context.getGiteaServerUrl());
    }

    GiteaChecksPublisher(GiteaChecksContext context, PluginLogger buildLogger, String giteaServerUrl) {
        this.context = context;
        this.buildLogger = buildLogger;
        this.giteaServerUrl = giteaServerUrl;
    }

    public void publish(ChecksDetails details) {
        try (GiteaConnection giteaConnection = GiteaChecksPublisher.connect(this.giteaServerUrl, this.context.getCredentials());){
            GiteaChecksDetails giteaDetails = new GiteaChecksDetails(details);
            this.publishGiteaCommitStatus(giteaConnection, giteaDetails);
            this.buildLogger.log("Gitea check (name: %s, status: %s, description: %s) has been published.", new Object[]{giteaDetails.getContextString(), giteaDetails.getStatus(), giteaDetails.getDescription()});
            SYSTEM_LOGGER.fine(String.format("Published check for repo: %s, sha: %s, job name: %s, name: %s, status: %s", this.context.getRepository(), this.context.getHeadSha(), this.context.getJob().getFullName(), giteaDetails.getContextString(), giteaDetails.getStatus()).replaceAll("[\r\n]", ""));
        }
        catch (IOException | InterruptedException e) {
            String message = "Failed Publishing Gitea checks: ";
            SYSTEM_LOGGER.log(Level.WARNING, (message + String.valueOf(details)).replaceAll("[\r\n]", ""), e);
            this.buildLogger.log(message + String.valueOf(e), new Object[0]);
        }
    }

    private static GiteaConnection connect(String serverUrl, StandardCredentials credentials) throws IOException, InterruptedException {
        return Gitea.server((String)serverUrl).as((GiteaAuth)AuthenticationTokens.convert(GiteaAuth.class, (Credentials)credentials)).open();
    }

    private GiteaCommitStatus publishGiteaCommitStatus(GiteaConnection giteaConnection, GiteaChecksDetails giteaChecksDetails) throws IOException, InterruptedException {
        GiteaCommitStatus commitStatus = new GiteaCommitStatus();
        giteaChecksDetails.getDetailsURL().ifPresent(arg_0 -> ((GiteaCommitStatus)commitStatus).setTargetUrl(arg_0));
        commitStatus.setContext(giteaChecksDetails.getContextString());
        giteaChecksDetails.getDescription().ifPresent(arg_0 -> ((GiteaCommitStatus)commitStatus).setDescription(arg_0));
        commitStatus.setState(giteaChecksDetails.getStatus());
        return giteaConnection.createCommitStatus(this.context.getRepoOwner(), this.context.getRepo(), this.context.getHeadSha(), commitStatus);
    }
}

