/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.gitea;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.checks.gitea.GiteaChecksContext;
import io.jenkins.plugins.checks.gitea.SCMFacade;
import java.util.Optional;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;

final class GiteaSCMSourceChecksContext
extends GiteaChecksContext {
    @CheckForNull
    private final String sha;
    @CheckForNull
    private final Run<?, ?> run;

    static GiteaSCMSourceChecksContext fromRun(Run<?, ?> run, String runURL, SCMFacade scmFacade) {
        return new GiteaSCMSourceChecksContext(run.getParent(), run, runURL, scmFacade);
    }

    static GiteaSCMSourceChecksContext fromJob(Job<?, ?> job, String runURL, SCMFacade scmFacade) {
        return new GiteaSCMSourceChecksContext(job, null, runURL, scmFacade);
    }

    private GiteaSCMSourceChecksContext(Job<?, ?> job, @CheckForNull Run<?, ?> run, String runURL, SCMFacade scmFacade) {
        super(job, runURL, scmFacade);
        this.run = run;
        this.sha = Optional.ofNullable(run).map(this::resolveHeadSha).orElse(this.resolveHeadSha(job));
    }

    @Override
    public String getHeadSha() {
        if (StringUtils.isBlank((CharSequence)this.sha)) {
            throw new IllegalStateException("No SHA found for job: " + this.getJob().getName());
        }
        return this.sha;
    }

    @Override
    public String getRepoOwner() {
        GiteaSCMSource source = this.resolveSource();
        if (source == null) {
            throw new IllegalStateException("No Gitea SCM source found for job: " + this.getJob().getName());
        }
        return source.getRepoOwner();
    }

    @Override
    public String getRepo() {
        GiteaSCMSource source = this.resolveSource();
        if (source == null) {
            throw new IllegalStateException("No Gitea SCM source found for job: " + this.getJob().getName());
        }
        return source.getRepository();
    }

    @Override
    public String getGiteaServerUrl() {
        GiteaSCMSource giteaSCMSource = this.getScmFacade().findGiteaSCMSource(this.getJob()).orElseThrow(() -> new IllegalArgumentException("Couldn't get GiteaSCMSource from job: " + this.getJob().getName()));
        return giteaSCMSource.getServerUrl();
    }

    @Override
    public String getRepository() {
        GiteaSCMSource source = this.resolveSource();
        if (source == null) {
            throw new IllegalStateException("No Gitea SCM source found for job: " + this.getJob().getName());
        }
        return source.getRepoOwner() + "/" + source.getRepository();
    }

    @Override
    public boolean isValid(FilteredLog logger) {
        logger.logError("Trying to resolve checks parameters from Gitea SCM...");
        if (this.resolveSource() == null) {
            logger.logError("Job does not use Gitea SCM");
            return false;
        }
        if (!this.hasValidCredentials(logger)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.sha)) {
            logger.logError("No HEAD SHA found for %s", new Object[]{this.getRepository()});
            return false;
        }
        return true;
    }

    @Override
    protected Optional<Run<?, ?>> getRun() {
        return Optional.ofNullable(this.run);
    }

    @Override
    @CheckForNull
    protected String getCredentialsId() {
        GiteaSCMSource source = this.resolveSource();
        if (source == null) {
            return null;
        }
        return source.getCredentialsId();
    }

    @CheckForNull
    private GiteaSCMSource resolveSource() {
        return this.getScmFacade().findGiteaSCMSource(this.getJob()).orElse(null);
    }

    @CheckForNull
    private String resolveHeadSha(Run<?, ?> theRun) {
        Optional<SCMRevision> revision;
        GiteaSCMSource source = this.resolveSource();
        if (source != null && (revision = this.getScmFacade().findRevision(source, theRun)).isPresent()) {
            return this.getScmFacade().findHash(revision.get()).orElse(null);
        }
        return null;
    }

    @CheckForNull
    private String resolveHeadSha(Job<?, ?> job) {
        Optional<SCMRevision> revision;
        GiteaSCMSource source = this.resolveSource();
        Optional<SCMHead> head = this.getScmFacade().findHead(job);
        if (source != null && head.isPresent() && (revision = this.getScmFacade().findRevision((SCMSource)source, head.get())).isPresent()) {
            return this.getScmFacade().findHash(revision.get()).orElse(null);
        }
        return null;
    }
}

