/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

public abstract class AbstractRepositoryCallback<T>
implements RepositoryCallback<T> {
    private static final long serialVersionUID = -5059963457602091209L;
    private static final String SLASH = "/";
    private static final String BACK_SLASH = "\\";

    public static String getWorkTree(Repository repository) {
        return AbstractRepositoryCallback.getAbsolutePath(repository.getWorkTree());
    }

    public static String getAbsolutePath(File absolute) {
        return AbstractRepositoryCallback.makeUnixPath(AbstractRepositoryCallback.resolve(absolute));
    }

    private static String resolve(File absolute) {
        try {
            return absolute.toPath().toAbsolutePath().normalize().toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
        }
        catch (IOException | InvalidPathException exception) {
            return absolute.toString();
        }
    }

    private static String makeUnixPath(String fileName) {
        return fileName.replace(BACK_SLASH, SLASH);
    }
}

