/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.miner;

import edu.hm.hafner.util.FilteredLog;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import io.jenkins.plugins.forensics.git.miner.GitRepositoryMiner;
import io.jenkins.plugins.forensics.git.util.GitRepositoryValidator;
import io.jenkins.plugins.forensics.miner.MinerFactory;
import io.jenkins.plugins.forensics.miner.RepositoryMiner;
import java.util.Optional;

@Extension
public class GitMinerFactory
extends MinerFactory {
    public Optional<RepositoryMiner> createMiner(SCM scm, Run<?, ?> build, FilePath workTree, TaskListener listener, FilteredLog logger) {
        GitRepositoryValidator validator = new GitRepositoryValidator(scm, build, workTree, listener, logger);
        if (validator.isGitRepository()) {
            logger.logInfo("-> Git miner successfully created in working tree '%s'", new Object[]{workTree});
            return Optional.of(new GitRepositoryMiner(validator.createClient()));
        }
        logger.logInfo("-> Git miner could not be created for SCM '%s' in working tree '%s'", new Object[]{scm, workTree});
        return Optional.empty();
    }
}

