/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.reference;

import hudson.model.Run;
import io.jenkins.plugins.forensics.git.reference.GitCommitsRecord;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class GitCommitsRecordAssert
extends AbstractObjectAssert<GitCommitsRecordAssert, GitCommitsRecord> {
    public GitCommitsRecordAssert(GitCommitsRecord actual) {
        super((Object)actual, GitCommitsRecordAssert.class);
    }

    @CheckReturnValue
    public static GitCommitsRecordAssert assertThat(GitCommitsRecord actual) {
        return new GitCommitsRecordAssert(actual);
    }

    public GitCommitsRecordAssert hasCommits(String ... commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommits(), (Object[])commits);
        return this;
    }

    public GitCommitsRecordAssert hasCommits(Collection<? extends String> commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommits(), commits.toArray());
        return this;
    }

    public GitCommitsRecordAssert hasOnlyCommits(String ... commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommits(), (Object[])commits);
        return this;
    }

    public GitCommitsRecordAssert hasOnlyCommits(Collection<? extends String> commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommits(), commits.toArray());
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveCommits(String ... commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommits(), (Object[])commits);
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveCommits(Collection<? extends String> commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommits(), commits.toArray());
        return this;
    }

    public GitCommitsRecordAssert hasNoCommits() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have commits but had :\n  <%s>";
        if (((GitCommitsRecord)this.actual).getCommits().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((GitCommitsRecord)this.actual).getCommits()});
        }
        return this;
    }

    public GitCommitsRecordAssert hasCommitsWithMerge(String ... commitsWithMerge) {
        this.isNotNull();
        if (commitsWithMerge == null) {
            this.failWithMessage("Expecting commitsWithMerge parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommitsWithMerge(), (Object[])commitsWithMerge);
        return this;
    }

    public GitCommitsRecordAssert hasCommitsWithMerge(Collection<? extends String> commitsWithMerge) {
        this.isNotNull();
        if (commitsWithMerge == null) {
            this.failWithMessage("Expecting commitsWithMerge parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommitsWithMerge(), commitsWithMerge.toArray());
        return this;
    }

    public GitCommitsRecordAssert hasOnlyCommitsWithMerge(String ... commitsWithMerge) {
        this.isNotNull();
        if (commitsWithMerge == null) {
            this.failWithMessage("Expecting commitsWithMerge parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommitsWithMerge(), (Object[])commitsWithMerge);
        return this;
    }

    public GitCommitsRecordAssert hasOnlyCommitsWithMerge(Collection<? extends String> commitsWithMerge) {
        this.isNotNull();
        if (commitsWithMerge == null) {
            this.failWithMessage("Expecting commitsWithMerge parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommitsWithMerge(), commitsWithMerge.toArray());
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveCommitsWithMerge(String ... commitsWithMerge) {
        this.isNotNull();
        if (commitsWithMerge == null) {
            this.failWithMessage("Expecting commitsWithMerge parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommitsWithMerge(), (Object[])commitsWithMerge);
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveCommitsWithMerge(Collection<? extends String> commitsWithMerge) {
        this.isNotNull();
        if (commitsWithMerge == null) {
            this.failWithMessage("Expecting commitsWithMerge parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getCommitsWithMerge(), commitsWithMerge.toArray());
        return this;
    }

    public GitCommitsRecordAssert hasNoCommitsWithMerge() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have commitsWithMerge but had :\n  <%s>";
        if (((GitCommitsRecord)this.actual).getCommitsWithMerge().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((GitCommitsRecord)this.actual).getCommitsWithMerge()});
        }
        return this;
    }

    public GitCommitsRecordAssert hasDisplayName(String displayName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting displayName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDisplayName = ((GitCommitsRecord)this.actual).getDisplayName();
        if (!Objects.deepEquals(actualDisplayName, displayName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, displayName, actualDisplayName});
        }
        return this;
    }

    public GitCommitsRecordAssert isEmpty() {
        this.isNotNull();
        if (!((GitCommitsRecord)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual GitCommitsRecord is empty but is not.", new Object[0]);
        }
        return this;
    }

    public GitCommitsRecordAssert isNotEmpty() {
        this.isNotNull();
        if (!((GitCommitsRecord)this.actual).isNotEmpty()) {
            this.failWithMessage("\nExpecting that actual GitCommitsRecord is not empty but is.", new Object[0]);
        }
        return this;
    }

    public GitCommitsRecordAssert hasErrorMessages(String ... errorMessages) {
        this.isNotNull();
        if (errorMessages == null) {
            this.failWithMessage("Expecting errorMessages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getErrorMessages(), (Object[])errorMessages);
        return this;
    }

    public GitCommitsRecordAssert hasErrorMessages(Collection<? extends String> errorMessages) {
        this.isNotNull();
        if (errorMessages == null) {
            this.failWithMessage("Expecting errorMessages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getErrorMessages(), errorMessages.toArray());
        return this;
    }

    public GitCommitsRecordAssert hasOnlyErrorMessages(String ... errorMessages) {
        this.isNotNull();
        if (errorMessages == null) {
            this.failWithMessage("Expecting errorMessages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getErrorMessages(), (Object[])errorMessages);
        return this;
    }

    public GitCommitsRecordAssert hasOnlyErrorMessages(Collection<? extends String> errorMessages) {
        this.isNotNull();
        if (errorMessages == null) {
            this.failWithMessage("Expecting errorMessages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getErrorMessages(), errorMessages.toArray());
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveErrorMessages(String ... errorMessages) {
        this.isNotNull();
        if (errorMessages == null) {
            this.failWithMessage("Expecting errorMessages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getErrorMessages(), (Object[])errorMessages);
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveErrorMessages(Collection<? extends String> errorMessages) {
        this.isNotNull();
        if (errorMessages == null) {
            this.failWithMessage("Expecting errorMessages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getErrorMessages(), errorMessages.toArray());
        return this;
    }

    public GitCommitsRecordAssert hasNoErrorMessages() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have errorMessages but had :\n  <%s>";
        if (((GitCommitsRecord)this.actual).getErrorMessages().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((GitCommitsRecord)this.actual).getErrorMessages()});
        }
        return this;
    }

    public GitCommitsRecordAssert isFirstBuild() {
        this.isNotNull();
        if (!((GitCommitsRecord)this.actual).isFirstBuild()) {
            this.failWithMessage("\nExpecting that actual GitCommitsRecord is first build but is not.", new Object[0]);
        }
        return this;
    }

    public GitCommitsRecordAssert isNotFirstBuild() {
        this.isNotNull();
        if (((GitCommitsRecord)this.actual).isFirstBuild()) {
            this.failWithMessage("\nExpecting that actual GitCommitsRecord is not first build but is.", new Object[0]);
        }
        return this;
    }

    public GitCommitsRecordAssert hasIconFileName(String iconFileName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting iconFileName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualIconFileName = ((GitCommitsRecord)this.actual).getIconFileName();
        if (!Objects.deepEquals(actualIconFileName, iconFileName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, iconFileName, actualIconFileName});
        }
        return this;
    }

    public GitCommitsRecordAssert hasInfoMessages(String ... infoMessages) {
        this.isNotNull();
        if (infoMessages == null) {
            this.failWithMessage("Expecting infoMessages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getInfoMessages(), (Object[])infoMessages);
        return this;
    }

    public GitCommitsRecordAssert hasInfoMessages(Collection<? extends String> infoMessages) {
        this.isNotNull();
        if (infoMessages == null) {
            this.failWithMessage("Expecting infoMessages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getInfoMessages(), infoMessages.toArray());
        return this;
    }

    public GitCommitsRecordAssert hasOnlyInfoMessages(String ... infoMessages) {
        this.isNotNull();
        if (infoMessages == null) {
            this.failWithMessage("Expecting infoMessages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getInfoMessages(), (Object[])infoMessages);
        return this;
    }

    public GitCommitsRecordAssert hasOnlyInfoMessages(Collection<? extends String> infoMessages) {
        this.isNotNull();
        if (infoMessages == null) {
            this.failWithMessage("Expecting infoMessages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getInfoMessages(), infoMessages.toArray());
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveInfoMessages(String ... infoMessages) {
        this.isNotNull();
        if (infoMessages == null) {
            this.failWithMessage("Expecting infoMessages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getInfoMessages(), (Object[])infoMessages);
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveInfoMessages(Collection<? extends String> infoMessages) {
        this.isNotNull();
        if (infoMessages == null) {
            this.failWithMessage("Expecting infoMessages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((GitCommitsRecord)this.actual).getInfoMessages(), infoMessages.toArray());
        return this;
    }

    public GitCommitsRecordAssert hasNoInfoMessages() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have infoMessages but had :\n  <%s>";
        if (((GitCommitsRecord)this.actual).getInfoMessages().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((GitCommitsRecord)this.actual).getInfoMessages()});
        }
        return this;
    }

    public GitCommitsRecordAssert hasLatestCommit(String latestCommit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting latestCommit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualLatestCommit = ((GitCommitsRecord)this.actual).getLatestCommit();
        if (!Objects.deepEquals(actualLatestCommit, latestCommit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, latestCommit, actualLatestCommit});
        }
        return this;
    }

    public GitCommitsRecordAssert hasLatestCommitLink(String latestCommitLink) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting latestCommitLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualLatestCommitLink = ((GitCommitsRecord)this.actual).getLatestCommitLink();
        if (!Objects.deepEquals(actualLatestCommitLink, latestCommitLink)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, latestCommitLink, actualLatestCommitLink});
        }
        return this;
    }

    public GitCommitsRecordAssert hasOwner(Run owner) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting owner of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Run actualOwner = ((GitCommitsRecord)this.actual).getOwner();
        if (!Objects.deepEquals(actualOwner, owner)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, owner, actualOwner});
        }
        return this;
    }

    public GitCommitsRecordAssert hasScmKey(String scmKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting scmKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualScmKey = ((GitCommitsRecord)this.actual).getScmKey();
        if (!Objects.deepEquals(actualScmKey, scmKey)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, scmKey, actualScmKey});
        }
        return this;
    }

    public GitCommitsRecordAssert hasSize(int size) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting size of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualSize = ((GitCommitsRecord)this.actual).getSize();
        if (actualSize != size) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, size, actualSize});
        }
        return this;
    }

    public GitCommitsRecordAssert hasTargetParentCommit(String targetParentCommit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting targetParentCommit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTargetParentCommit = ((GitCommitsRecord)this.actual).getTargetParentCommit();
        if (!Objects.deepEquals(actualTargetParentCommit, targetParentCommit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, targetParentCommit, actualTargetParentCommit});
        }
        return this;
    }

    public GitCommitsRecordAssert hasTargetParentCommit() {
        this.isNotNull();
        if (!((GitCommitsRecord)this.actual).hasTargetParentCommit()) {
            this.failWithMessage("\nExpecting that actual GitCommitsRecord has target parent commit but does not have.", new Object[0]);
        }
        return this;
    }

    public GitCommitsRecordAssert doesNotHaveTargetParentCommit() {
        this.isNotNull();
        if (((GitCommitsRecord)this.actual).hasTargetParentCommit()) {
            this.failWithMessage("\nExpecting that actual GitCommitsRecord does not have target parent commit but has.", new Object[0]);
        }
        return this;
    }

    public GitCommitsRecordAssert hasUrlName(String urlName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting urlName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualUrlName = ((GitCommitsRecord)this.actual).getUrlName();
        if (!Objects.deepEquals(actualUrlName, urlName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, urlName, actualUrlName});
        }
        return this;
    }
}

