/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitcollect;

import hudson.EnvVars;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Run;
import io.jenkins.plugins.gitcollect.LocalGitInfo;

public class MultiScmEnvAction
implements EnvironmentContributingAction {
    private final LocalGitInfo info;

    public MultiScmEnvAction(LocalGitInfo info) {
        this.info = info;
    }

    public void buildEnvironment(Run<?, ?> run, EnvVars env) {
        env.put("GIT_COMMIT", this.info.getShaRevision());
        env.put("GIT_BRANCH", this.info.getBranch());
        env.put("GIT_URL", this.info.getRemoteUrl());
        String safeName = this.info.getScmName().replaceAll("[^a-zA-Z0-9_]", "_");
        env.put("GIT_COMMIT_" + safeName, this.info.getShaRevision());
        env.put("GIT_BRANCH_" + safeName, this.info.getBranch());
        env.put("GIT_URL_" + safeName, this.info.getRemoteUrl());
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

