/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gerritchecksapi.rest;

import com.google.inject.Singleton;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.gerritchecksapi.PatchSetId;
import io.jenkins.plugins.gerritchecksapi.rest.AbstractCheckRunFactory;
import io.jenkins.plugins.gerritchecksapi.rest.Action;
import io.jenkins.plugins.gerritchecksapi.rest.CheckRun;
import io.jenkins.plugins.gerritchecksapi.rest.GerritMultiBranchRerunAction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class GerritMultiBranchCheckRunFactory
extends AbstractCheckRunFactory {
    @Override
    public CheckRun create(PatchSetId ps, Job<?, ?> job, Run<?, ?> run, int attempt) {
        CheckRun checkRun = new CheckRun();
        checkRun.setChange(ps.changeId());
        checkRun.setPatchSet(ps.patchSetNumber());
        checkRun.setAttempt(attempt);
        checkRun.setExternalId(run.getExternalizableId());
        checkRun.setCheckName(job.getParent().getDisplayName());
        checkRun.setCheckDescription(job.getDescription());
        checkRun.setCheckLink(this.getAbsoluteRunUrl(run));
        checkRun.setStatus(GerritMultiBranchCheckRunFactory.computeStatus(run));
        checkRun.setStatusDescription(run.getBuildStatusSummary().message);
        checkRun.setStatusLink(this.getAbsoluteRunUrl(run));
        checkRun.setLabelName(null);
        checkRun.setActions(this.computeActions(run));
        checkRun.setScheduledTimestamp(run.getTime().toInstant().toString());
        checkRun.setStartedTimestamp(Instant.ofEpochMilli(run.getStartTimeInMillis()).toString());
        checkRun.setFinishedTimestamp(GerritMultiBranchCheckRunFactory.computeFinishedTimeStamp(run));
        checkRun.setResults(this.computeCheckResults(run));
        return checkRun;
    }

    @Override
    protected List<Action> computeActions(Run<?, ?> run) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new GerritMultiBranchRerunAction(run.getParent().getAbsoluteUrl()));
        return actions;
    }
}

