/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gerritchecksapi;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import hudson.model.Job;
import io.jenkins.plugins.gerritchecksapi.Caching;
import io.jenkins.plugins.gerritchecksapi.CheckRunCollector;
import io.jenkins.plugins.gerritchecksapi.PatchSetId;
import io.jenkins.plugins.gerritchecksapi.rest.CheckRun;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;

@Singleton
public class PermissionAwareCheckRunCollector
implements CheckRunCollector {
    private final CheckRunCollector cachingCollector;
    private final Jenkins jenkins;

    @Inject
    PermissionAwareCheckRunCollector(@Caching CheckRunCollector cachingCollector, Jenkins jenkins) {
        this.cachingCollector = cachingCollector;
        this.jenkins = jenkins;
    }

    @Override
    public Map<Job<?, ?>, List<CheckRun>> collectFor(PatchSetId ps) {
        HashMap result = new HashMap();
        Map<Job<?, ?>, List<CheckRun>> cached = this.cachingCollector.collectFor(ps);
        for (Map.Entry<Job<?, ?>, List<CheckRun>> entry : cached.entrySet()) {
            if (!this.jenkins.getAuthorizationStrategy().getACL(entry.getKey()).hasPermission(Job.READ)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

