/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gerritchecksapi;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import hudson.model.Job;
import io.jenkins.plugins.gerritchecksapi.CheckRunCollector;
import io.jenkins.plugins.gerritchecksapi.Direct;
import io.jenkins.plugins.gerritchecksapi.PatchSetId;
import io.jenkins.plugins.gerritchecksapi.rest.CheckRun;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Singleton
public class CachingCheckRunCollector
implements CheckRunCollector {
    private final Cache<PatchSetId, Map<Job<?, ?>, List<CheckRun>>> cache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final CheckRunCollector directCollector;

    @Inject
    CachingCheckRunCollector(@Direct CheckRunCollector directCollector) {
        this.directCollector = directCollector;
    }

    @Override
    public Map<Job<?, ?>, List<CheckRun>> collectFor(PatchSetId ps) {
        return (Map)this.cache.get((Object)ps, p -> this.directCollector.collectFor((PatchSetId)p));
    }
}

