/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.generic.event;

import io.jenkins.plugins.generic.event.MetaData;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class Event {
    private String type;
    private String source;
    private String url;
    private String id;
    private Instant time;
    private String dataType;
    private Object data;
    private MetaData metaData;

    public Event(EventBuilder builder) {
        this.type = builder.type;
        this.source = builder.source;
        this.url = builder.url;
        this.id = builder.id;
        this.time = builder.time;
        this.dataType = builder.dataType;
        this.data = builder.data;
        this.metaData = builder.metaData;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Instant getTime() {
        return this.time;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.type, event.type) && Objects.equals(this.source, event.source) && Objects.equals(this.url, event.url) && Objects.equals(this.id, event.id) && Objects.equals(this.time, event.time) && Objects.equals(this.dataType, event.dataType) && Objects.equals(this.data, event.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.source, this.url, this.id, this.time, this.dataType, this.data);
    }

    public String getUrlData() {
        return "item.locationChanged".equals(this.type) ? ", metaData=" + this.metaData.toString() : ", url=" + this.url;
    }

    public String toString() {
        return "Event [data=" + String.valueOf(this.data) + ", dataType=" + this.dataType + ", id=" + this.id + ", source=" + this.source + this.getUrlData() + ", time=" + String.valueOf(this.time) + ", type=" + this.type + "]";
    }

    public static class EventBuilder {
        private String type;
        private String source;
        private String url;
        private String id;
        private Instant time;
        private String dataType;
        private Object data;
        private MetaData metaData;

        public EventBuilder type(String type) {
            this.type = type;
            return this;
        }

        public EventBuilder source(String source) {
            this.source = source;
            return this;
        }

        public EventBuilder url(String url) {
            this.url = url;
            return this;
        }

        public EventBuilder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public EventBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public EventBuilder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Event build() {
            if (StringUtils.isBlank((String)this.dataType) && this.data != null) {
                this.dataType = this.data.getClass().getName();
            }
            this.id = UUID.randomUUID().toString();
            this.time = Instant.now();
            return new Event(this);
        }
    }
}

