// CHECKSTYLE:OFF

package io.jenkins.plugins.credentials.gcp.secretsmanager.config;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code secretText}: {@code GCP Secrets Manager Secret Text}.
     * 
     * @return
     *     {@code GCP Secrets Manager Secret Text}
     */
    public static String secretText() {
        return holder.format("secretText");
    }

    /**
     * Key {@code secretText}: {@code GCP Secrets Manager Secret Text}.
     * 
     * @return
     *     {@code GCP Secrets Manager Secret Text}
     */
    public static Localizable _secretText() {
        return new Localizable(holder, "secretText");
    }

    /**
     * Key {@code file}: {@code GCP Secrets Manager Secret file}.
     * 
     * @return
     *     {@code GCP Secrets Manager Secret file}
     */
    public static String file() {
        return holder.format("file");
    }

    /**
     * Key {@code file}: {@code GCP Secrets Manager Secret file}.
     * 
     * @return
     *     {@code GCP Secrets Manager Secret file}
     */
    public static Localizable _file() {
        return new Localizable(holder, "file");
    }

    /**
     * Key {@code gcpSecretsManager}: {@code GCP Secrets Manager}.
     * 
     * @return
     *     {@code GCP Secrets Manager}
     */
    public static String gcpSecretsManager() {
        return holder.format("gcpSecretsManager");
    }

    /**
     * Key {@code gcpSecretsManager}: {@code GCP Secrets Manager}.
     * 
     * @return
     *     {@code GCP Secrets Manager}
     */
    public static Localizable _gcpSecretsManager() {
        return new Localizable(holder, "gcpSecretsManager");
    }

    /**
     * Key {@code couldNotRetrieveCredentialError}: {@code Could not retrieve
     * the credentials from GCP Secrets Manager}.
     * 
     * @return
     *     {@code Could not retrieve the credentials from GCP Secrets Manager}
     */
    public static String couldNotRetrieveCredentialError() {
        return holder.format("couldNotRetrieveCredentialError");
    }

    /**
     * Key {@code couldNotRetrieveCredentialError}: {@code Could not retrieve
     * the credentials from GCP Secrets Manager}.
     * 
     * @return
     *     {@code Could not retrieve the credentials from GCP Secrets Manager}
     */
    public static Localizable _couldNotRetrieveCredentialError() {
        return new Localizable(holder, "couldNotRetrieveCredentialError");
    }

    /**
     * Key {@code gcpSecretsManagerSecret}: {@code GCP Secrets Manager
     * Secret}.
     * 
     * @return
     *     {@code GCP Secrets Manager Secret}
     */
    public static String gcpSecretsManagerSecret() {
        return holder.format("gcpSecretsManagerSecret");
    }

    /**
     * Key {@code gcpSecretsManagerSecret}: {@code GCP Secrets Manager
     * Secret}.
     * 
     * @return
     *     {@code GCP Secrets Manager Secret}
     */
    public static Localizable _gcpSecretsManagerSecret() {
        return new Localizable(holder, "gcpSecretsManagerSecret");
    }

    /**
     * Key {@code certificate}: {@code GCP Secrets Manager Certificate}.
     * 
     * @return
     *     {@code GCP Secrets Manager Certificate}
     */
    public static String certificate() {
        return holder.format("certificate");
    }

    /**
     * Key {@code certificate}: {@code GCP Secrets Manager Certificate}.
     * 
     * @return
     *     {@code GCP Secrets Manager Certificate}
     */
    public static Localizable _certificate() {
        return new Localizable(holder, "certificate");
    }

    /**
     * Key {@code sshUserPrivateKey}: {@code GCP Secrets Manager SSH User
     * Private Key}.
     * 
     * @return
     *     {@code GCP Secrets Manager SSH User Private Key}
     */
    public static String sshUserPrivateKey() {
        return holder.format("sshUserPrivateKey");
    }

    /**
     * Key {@code sshUserPrivateKey}: {@code GCP Secrets Manager SSH User
     * Private Key}.
     * 
     * @return
     *     {@code GCP Secrets Manager SSH User Private Key}
     */
    public static Localizable _sshUserPrivateKey() {
        return new Localizable(holder, "sshUserPrivateKey");
    }

    /**
     * Key {@code usernamePassword}: {@code GCP Secrets Manager Username With
     * Password}.
     * 
     * @return
     *     {@code GCP Secrets Manager Username With Password}
     */
    public static String usernamePassword() {
        return holder.format("usernamePassword");
    }

    /**
     * Key {@code usernamePassword}: {@code GCP Secrets Manager Username With
     * Password}.
     * 
     * @return
     *     {@code GCP Secrets Manager Username With Password}
     */
    public static Localizable _usernamePassword() {
        return new Localizable(holder, "usernamePassword");
    }

}
