/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.finitestate;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.finitestate.BaseFiniteStateRecorder;
import java.io.IOException;

public class FiniteStateExecutionFramework {
    private FiniteStateExecutionFramework() {
    }

    public static boolean executeAnalysis(BaseFiniteStateRecorder recorder, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        FilePath cltPath;
        listener.getLogger().println("Starting Finite State " + recorder.getAnalysisType() + "...");
        if (!recorder.validateCommonFields(listener)) {
            return false;
        }
        String parsedApiToken = recorder.getSecretTextValue(run, recorder.getApiTokenCredentialsId());
        if (parsedApiToken == null) {
            String errorMessage = "ERROR: Could not retrieve API token from credentials";
            listener.getLogger().println(errorMessage);
            String consoleOutput = errorMessage + "\nProject: " + recorder.getProjectName() + "\nCredential ID: " + recorder.getApiTokenCredentialsId();
            recorder.addConsolidatedResult(run, recorder.getAnalysisType(), recorder.getProjectName(), consoleOutput, "ERROR", "N/A");
            return false;
        }
        String parsedVersion = recorder.parseVersion(run, recorder.getProjectVersion());
        recorder.logCommonInfo(run, listener, recorder.getFilePathValue());
        try {
            cltPath = recorder.getCLTPath(workspace, recorder.getSubdomain(), parsedApiToken, listener);
        }
        catch (IOException e) {
            String errorMessage = "ERROR: Failed to download CLT: " + e.getMessage();
            listener.getLogger().println(errorMessage);
            String consoleOutput = errorMessage + "\nProject: " + recorder.getProjectName() + "\nSubdomain: " + recorder.getSubdomain() + "\nCredential ID: " + recorder.getApiTokenCredentialsId();
            recorder.addConsolidatedResult(run, recorder.getAnalysisType(), recorder.getProjectName(), consoleOutput, "ERROR", "N/A");
            return false;
        }
        FilePath fileObj = recorder.getFileFromWorkspace(workspace, recorder.getFilePathValue(), listener);
        if (fileObj == null || !fileObj.exists()) {
            String errorMessage = "ERROR: " + recorder.getFilePathFieldName() + " not found: " + recorder.getFilePathValue();
            listener.getLogger().println(errorMessage);
            String consoleOutput = errorMessage + "\nProject: " + recorder.getProjectName() + "\n" + recorder.getFilePathFieldName() + ": " + recorder.getFilePathValue();
            recorder.addConsolidatedResult(run, recorder.getAnalysisType(), recorder.getProjectName(), consoleOutput, "ERROR", "N/A");
            return false;
        }
        listener.getLogger().println("Executing Finite State " + recorder.getAnalysisType() + "...");
        int exitCode = recorder.executeAnalysis(cltPath, fileObj, recorder.getProjectName(), parsedVersion, parsedApiToken, workspace, launcher, listener);
        return FiniteStateExecutionFramework.handleExitCode(recorder, run, listener, exitCode, parsedVersion);
    }

    public static boolean executeAnalysis(BaseFiniteStateRecorder recorder, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = build.getWorkspace();
        return FiniteStateExecutionFramework.executeAnalysis(recorder, build, workspace, launcher, (TaskListener)listener);
    }

    private static boolean handleExitCode(BaseFiniteStateRecorder recorder, Run<?, ?> run, TaskListener listener, int exitCode, String parsedVersion) {
        String scanUrl = "https://" + recorder.getSubdomain();
        if (exitCode == 0) {
            String consoleOutput = FiniteStateExecutionFramework.buildSuccessMessage(recorder, parsedVersion, exitCode);
            recorder.addConsolidatedResult(run, recorder.getAnalysisType(), recorder.getProjectName(), consoleOutput, "SUCCESS", scanUrl);
            listener.getLogger().println("\u2705 Finite State " + recorder.getAnalysisType() + " started successfully!");
            return true;
        }
        if (exitCode == 1) {
            String consoleOutput = FiniteStateExecutionFramework.buildWarningMessage(recorder, parsedVersion, exitCode);
            recorder.addConsolidatedResult(run, recorder.getAnalysisType(), recorder.getProjectName(), consoleOutput, "WARNING", scanUrl);
            listener.getLogger().println("\u26a0\ufe0f Finite State " + recorder.getAnalysisType() + " completed with vulnerabilities found.");
            return true;
        }
        String consoleOutput = FiniteStateExecutionFramework.buildErrorMessage(recorder, parsedVersion, exitCode);
        recorder.addConsolidatedResult(run, recorder.getAnalysisType(), recorder.getProjectName(), consoleOutput, "ERROR", "N/A");
        listener.getLogger().println("\u274c Finite State " + recorder.getAnalysisType() + " failed with exit code: " + exitCode);
        return false;
    }

    private static String buildSuccessMessage(BaseFiniteStateRecorder recorder, String parsedVersion, int exitCode) {
        return "Finite State " + recorder.getAnalysisType() + " started successfully!\n" + recorder.getFilePathFieldName() + ": " + recorder.getFilePathValue() + "\nProject Version: " + parsedVersion + "\nExit Code: " + exitCode;
    }

    private static String buildWarningMessage(BaseFiniteStateRecorder recorder, String parsedVersion, int exitCode) {
        return "Finite State " + recorder.getAnalysisType() + " completed with vulnerabilities found.\n" + recorder.getFilePathFieldName() + ": " + recorder.getFilePathValue() + "\nProject Version: " + parsedVersion + "\nExit Code: " + exitCode;
    }

    private static String buildErrorMessage(BaseFiniteStateRecorder recorder, String parsedVersion, int exitCode) {
        return "Finite State " + recorder.getAnalysisType() + " failed with exit code: " + exitCode + "\n" + recorder.getFilePathFieldName() + ": " + recorder.getFilePathValue() + "\nProject Version: " + parsedVersion + "\nExit Code: " + exitCode;
    }
}

