/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.finitestate;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class BaseFiniteStateDescriptor
extends BuildStepDescriptor<Publisher> {
    protected BaseFiniteStateDescriptor() {
    }

    @RequirePOST
    public ListBoxModel doFillApiTokenCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String apiTokenCredentialsId) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.CONFIGURE)) {
            return result.includeCurrentValue(apiTokenCredentialsId);
        }
        result.add("", "Select API Token Credentials");
        result.includeAs(ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList());
        return result.includeCurrentValue(apiTokenCredentialsId);
    }

    protected FormValidation checkRequiredValue(String value) {
        if (value == null || value.isBlank()) {
            return FormValidation.error((String)"This field is required");
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doCheckSubdomain(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
        return this.checkRequiredValue(value);
    }

    @RequirePOST
    public FormValidation doCheckApiTokenCredentialsId(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
        return this.checkRequiredValue(value);
    }

    @RequirePOST
    public FormValidation doCheckProjectName(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
        return this.checkRequiredValue(value);
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }
}

