/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.finitestate;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.jenkins.plugins.finitestate.BaseFiniteStateDescriptor;
import io.jenkins.plugins.finitestate.BaseFiniteStateRecorder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class FiniteStateSBOMImportRecorder
extends BaseFiniteStateRecorder {
    private String sbomFilePath;

    @DataBoundConstructor
    public FiniteStateSBOMImportRecorder(String subdomain, String apiTokenCredentialsId, String sbomFilePath, String projectName) {
        this.subdomain = subdomain;
        this.apiTokenCredentialsId = apiTokenCredentialsId;
        this.sbomFilePath = sbomFilePath;
        this.projectName = projectName;
    }

    public String getSbomFilePath() {
        return this.sbomFilePath;
    }

    @DataBoundSetter
    public void setSbomFilePath(String sbomFilePath) {
        this.sbomFilePath = sbomFilePath;
    }

    @Override
    protected int executeAnalysis(FilePath cltPath, FilePath filePath, String projectName, String projectVersion, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return this.executeSBOMImport(cltPath, filePath, projectName, projectVersion, this.getPreRelease(), workspace, launcher, listener);
    }

    @Override
    protected String getAnalysisType() {
        return "SBOM Import";
    }

    @Override
    protected String getFilePathFieldName() {
        return "SBOM file";
    }

    @Override
    protected String getFilePathValue() {
        return this.sbomFilePath;
    }

    private int executeSBOMImport(FilePath cltPath, FilePath sbomFile, String projectName, String projectVersion, boolean preRelease, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("java");
        command.add("-jar");
        command.add(cltPath.getRemote());
        command.add("--import");
        command.add("--name=" + projectName);
        command.add("--version=" + projectVersion);
        command.add(sbomFile.getRemote());
        if (preRelease) {
            command.add("--pre-release");
        }
        listener.getLogger().println("Executing command: " + String.join((CharSequence)" ", command));
        Launcher.ProcStarter starter = launcher.launch();
        starter.cmds(command);
        starter.stdout((OutputStream)listener.getLogger());
        starter.stderr((OutputStream)listener.getLogger());
        starter.pwd(workspace);
        return starter.join();
    }

    @Symbol(value={"finiteStateImportSbom"})
    @Extension
    public static final class DescriptorImpl
    extends BaseFiniteStateDescriptor {
        @RequirePOST
        public FormValidation doCheckSbomFilePath(@QueryParameter String value) throws IOException, ServletException {
            return this.checkRequiredValue(value);
        }

        public String getDisplayName() {
            return "Finite State Import SBOM";
        }
    }
}

