/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.finitestate;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.jenkins.plugins.finitestate.BaseFiniteStateDescriptor;
import io.jenkins.plugins.finitestate.BaseFiniteStateRecorder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class FiniteStateAnalyzeBinaryRecorder
extends BaseFiniteStateRecorder {
    private String binaryFilePath;
    private Boolean scaEnabled;
    private Boolean sastEnabled;
    private Boolean configEnabled;

    @DataBoundConstructor
    public FiniteStateAnalyzeBinaryRecorder(String subdomain, String apiTokenCredentialsId, String binaryFilePath, String projectName) {
        this.subdomain = subdomain;
        this.apiTokenCredentialsId = apiTokenCredentialsId;
        this.binaryFilePath = binaryFilePath;
        this.projectName = projectName;
    }

    public String getBinaryFilePath() {
        return this.binaryFilePath;
    }

    public boolean getScaEnabled() {
        return this.scaEnabled != null ? this.scaEnabled : true;
    }

    public boolean getSastEnabled() {
        return this.sastEnabled != null ? this.sastEnabled : false;
    }

    public boolean getConfigEnabled() {
        return this.configEnabled != null ? this.configEnabled : false;
    }

    @DataBoundSetter
    public void setBinaryFilePath(String binaryFilePath) {
        this.binaryFilePath = binaryFilePath;
    }

    @DataBoundSetter
    public void setScaEnabled(boolean scaEnabled) {
        this.scaEnabled = scaEnabled;
    }

    @DataBoundSetter
    public void setSastEnabled(boolean sastEnabled) {
        this.sastEnabled = sastEnabled;
    }

    @DataBoundSetter
    public void setConfigEnabled(boolean configEnabled) {
        this.configEnabled = configEnabled;
    }

    @Override
    protected int executeAnalysis(FilePath cltPath, FilePath filePath, String projectName, String projectVersion, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return this.executeCLT(cltPath, filePath, projectName, projectVersion, this.buildScanTypesString(), this.getPreRelease(), workspace, launcher, listener);
    }

    @Override
    protected String getAnalysisType() {
        return "Binary Analysis";
    }

    @Override
    protected String getFilePathFieldName() {
        return "Binary file";
    }

    @Override
    protected String getFilePathValue() {
        return this.binaryFilePath;
    }

    private String buildScanTypesString() {
        ArrayList<String> selectedTypes = new ArrayList<String>();
        if (this.getScaEnabled()) {
            selectedTypes.add("sca");
        }
        if (this.getSastEnabled()) {
            selectedTypes.add("sast");
        }
        if (this.getConfigEnabled()) {
            selectedTypes.add("config");
        }
        if (selectedTypes.isEmpty()) {
            selectedTypes.add("sca");
        }
        return String.join((CharSequence)",", selectedTypes);
    }

    private int executeCLT(FilePath cltPath, FilePath binaryFile, String projectName, String projectVersion, String scanTypes, boolean preRelease, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String computedScanTypes;
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("java");
        command.add("-jar");
        command.add(cltPath.getRemote());
        command.add("--upload");
        command.add(binaryFile.getRemote());
        command.add("--name=" + projectName);
        if (projectVersion != null && !projectVersion.isBlank()) {
            command.add("--version=" + projectVersion);
        }
        if ((computedScanTypes = this.buildScanTypesString()) != null && !computedScanTypes.isBlank()) {
            command.add("--upload=" + computedScanTypes);
        }
        if (preRelease) {
            command.add("--pre-release");
        }
        listener.getLogger().println("Executing command: " + String.join((CharSequence)" ", command));
        Launcher.ProcStarter starter = launcher.launch();
        starter.cmds(command);
        starter.stdout((OutputStream)listener.getLogger());
        starter.stderr((OutputStream)listener.getLogger());
        starter.pwd(workspace);
        int exitCode = starter.join();
        if (exitCode != 0) {
            listener.getLogger().println("Finite State scan failed with exit code: " + exitCode);
        }
        return exitCode;
    }

    @Symbol(value={"finiteStateAnalyzeBinary"})
    @Extension
    public static final class DescriptorImpl
    extends BaseFiniteStateDescriptor {
        @RequirePOST
        public FormValidation doCheckBinaryFilePath(@QueryParameter String value) throws IOException, ServletException {
            return this.checkRequiredValue(value);
        }

        public String getDisplayName() {
            return "Finite State Analyze Binary";
        }
    }
}

