/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.finitestate;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Recorder;
import io.jenkins.plugins.finitestate.CLTManager;
import io.jenkins.plugins.finitestate.FiniteStateConsolidatedResultsAction;
import io.jenkins.plugins.finitestate.FiniteStateExecutionFramework;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class BaseFiniteStateRecorder
extends Recorder
implements SimpleBuildStep {
    protected String subdomain;
    protected String apiTokenCredentialsId;
    protected String projectName;
    protected String projectVersion;
    protected Boolean externalizableId;
    protected Boolean preRelease;

    protected BaseFiniteStateRecorder() {
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public String getApiTokenCredentialsId() {
        return this.apiTokenCredentialsId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public boolean getExternalizableId() {
        return this.externalizableId != null ? this.externalizableId : false;
    }

    public boolean getPreRelease() {
        return this.preRelease != null ? this.preRelease : false;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    @DataBoundSetter
    public void setApiTokenCredentialsId(String apiTokenCredentialsId) {
        this.apiTokenCredentialsId = apiTokenCredentialsId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @DataBoundSetter
    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    @DataBoundSetter
    public void setExternalizableId(boolean externalizableId) {
        this.externalizableId = externalizableId;
    }

    @DataBoundSetter
    public void setPreRelease(boolean preRelease) {
        this.preRelease = preRelease;
    }

    protected FilePath getFileFromWorkspace(FilePath workspace, String relativeFilePath, TaskListener listener) throws IOException, InterruptedException {
        if (workspace != null) {
            FilePath child = workspace.child(relativeFilePath);
            listener.getLogger().println("Looking for file at: " + child.getRemote());
            return child;
        }
        listener.getLogger().println("ERROR: Could not determine workspace path");
        return null;
    }

    protected String getSecretTextValue(Run<?, ?> run, String credentialId) {
        StandardCredentials credentials = (StandardCredentials)CredentialsProvider.findCredentialById((String)credentialId, StringCredentials.class, run);
        if (credentials instanceof StringCredentials) {
            StringCredentials stringCredentials = (StringCredentials)credentials;
            return stringCredentials.getSecret().getPlainText();
        }
        return null;
    }

    protected FilePath getCLTPath(FilePath workspace, String subdomain, String apiToken, TaskListener listener) throws IOException, InterruptedException {
        String cltUrl = "https://" + subdomain + "/api/config/clt";
        return CLTManager.getOrDownloadCLT(cltUrl, apiToken, subdomain, workspace, listener);
    }

    protected String parseVersion(Run<?, ?> run, String projectVersion) {
        if (this.getExternalizableId()) {
            return run.getExternalizableId();
        }
        return projectVersion;
    }

    protected boolean validateCommonFields(TaskListener listener) {
        if (this.subdomain == null || this.subdomain.isBlank()) {
            listener.getLogger().println("ERROR: Subdomain is required");
            return false;
        }
        String credentialsId = this.getApiTokenCredentialsId();
        if (credentialsId == null || credentialsId.isBlank()) {
            listener.getLogger().println("ERROR: API Token credentials ID is required");
            return false;
        }
        if (this.projectName == null || this.projectName.isBlank()) {
            listener.getLogger().println("ERROR: Project name is required");
            return false;
        }
        return true;
    }

    protected void logCommonInfo(Run<?, ?> run, TaskListener listener, String filePath) {
        String parsedVersion;
        listener.getLogger().println("Subdomain: " + this.subdomain);
        listener.getLogger().println("Project: " + this.projectName);
        if (filePath != null) {
            listener.getLogger().println("File: " + filePath);
        }
        if ((parsedVersion = this.parseVersion(run, this.projectVersion)) != null && !parsedVersion.isBlank()) {
            listener.getLogger().println("Project version: " + parsedVersion);
        }
    }

    protected void addConsolidatedResult(Run<?, ?> run, String analysisType, String projectName, String consoleOutput, String status, String url) {
        FiniteStateConsolidatedResultsAction.getOrCreate(run).addResult(analysisType, projectName, consoleOutput, status, url);
    }

    protected abstract int executeAnalysis(FilePath var1, FilePath var2, String var3, String var4, FilePath var5, Launcher var6, TaskListener var7) throws IOException, InterruptedException;

    protected abstract String getAnalysisType();

    protected abstract String getFilePathFieldName();

    protected abstract String getFilePathValue();

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean ok = FiniteStateExecutionFramework.executeAnalysis(this, run, workspace, launcher, listener);
        if (!ok) {
            throw new AbortException("Finite State analysis failed");
        }
    }
}

