/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.file_parameters;

import hudson.cli.CLICommand;
import hudson.model.Failure;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import io.jenkins.plugins.file_parameters.AbstractFileParameterValue;
import jakarta.servlet.ServletException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileUploadContentTypeException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

abstract class AbstractFileParameterDefinition
extends ParameterDefinition {
    protected AbstractFileParameterDefinition(String name) {
        super(name);
        Jenkins.checkGoodName((String)name);
    }

    protected Object readResolve() {
        Jenkins.checkGoodName((String)this.getName());
        return this;
    }

    protected abstract Class<? extends AbstractFileParameterValue> valueType();

    protected abstract AbstractFileParameterValue createValue(String var1, InputStream var2) throws IOException;

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        AbstractFileParameterValue p = (AbstractFileParameterValue)((Object)req.bindJSON(this.valueType(), jo));
        p.setDescription(this.getDescription());
        return p;
    }

    public ParameterValue createValue(StaplerRequest2 req) {
        try {
            AbstractFileParameterValue p;
            FileItem src;
            try {
                src = req.getFileItem2(this.getName());
            }
            catch (ServletException x) {
                if (x.getCause() instanceof FileUploadContentTypeException) {
                    src = null;
                }
                throw x;
            }
            if (src == null) {
                return null;
            }
            try (InputStream in = src.getInputStream();){
                p = this.createValue(this.getName(), in);
            }
            src.delete();
            p.setDescription(this.getDescription());
            p.setFilename(src.getName());
            return p;
        }
        catch (ServletException | IOException x) {
            throw new RuntimeException(x);
        }
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        AbstractFileParameterValue p;
        if (value.isEmpty()) {
            p = this.createValue(this.getName(), command.stdin);
        } else {
            byte[] data = Base64.getDecoder().decode(value);
            p = this.createValue(this.getName(), new ByteArrayInputStream(data));
        }
        p.setDescription(this.getDescription());
        return p;
    }

    protected static abstract class AbstractFileParameterDefinitionDescriptor
    extends ParameterDefinition.ParameterDescriptor {
        protected AbstractFileParameterDefinitionDescriptor() {
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            try {
                Jenkins.checkGoodName((String)name);
                return FormValidation.ok();
            }
            catch (Failure x) {
                return FormValidation.error((String)x.getMessage());
            }
        }
    }
}

