/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.AbstractExtraToolInstaller;
import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.RestrictedSince;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.CommandInstaller;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SharedDirectoryInstaller
extends AbstractExtraToolInstaller {
    @DataBoundConstructor
    public SharedDirectoryInstaller(String label, String toolHome, boolean failOnSubstitution) {
        super(label, toolHome, failOnSubstitution);
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        String substitutedHome = this.substituteNodeVariablesValidated("Tool Home", this.getToolHome(), node);
        FilePath dir = this.preferredLocation(tool, node);
        return dir.child(substitutedHome);
    }

    @Extension
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<CommandInstaller> {
        public String getDisplayName() {
            return Messages.SharedDirectoryInstaller_DescriptorImpl_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        @RestrictedSince(value="0.4")
        public FormValidation doCheckToolHome(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.SharedDirectoryInstaller_no_toolHome());
        }
    }
}

