/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extended_timer_trigger;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.scheduler.CronTab;
import hudson.scheduler.CronTabList;
import io.jenkins.plugins.extended_timer_trigger.ExtendedCronTab;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

public class CronTabWrapper {
    private final CronTabList cronTabList;
    private final CronTab cronTab;
    private final ExtendedCronTab extendedCronTab;
    private Map<String, String> parameters;

    public CronTabWrapper(CronTabList cronTabList, CronTab cronTab) {
        this.cronTabList = cronTabList;
        this.extendedCronTab = null;
        this.cronTab = cronTab;
    }

    public CronTabWrapper(ExtendedCronTab extendedCronTab) {
        this.extendedCronTab = extendedCronTab;
        this.cronTabList = null;
        this.cronTab = null;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @CheckForNull
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean check(ZonedDateTime time) {
        if (this.cronTabList != null) {
            GregorianCalendar cal = GregorianCalendar.from(time);
            return this.cronTabList.check((Calendar)cal);
        }
        if (this.extendedCronTab != null) {
            return this.extendedCronTab.check(time);
        }
        return false;
    }

    @CheckForNull
    @SuppressRestrictedWarnings(value={CronTabList.class})
    public ZonedDateTime previous() {
        if (this.cronTabList != null) {
            Calendar scheduled = this.cronTabList.previous();
            if (scheduled != null) {
                return ZonedDateTime.ofInstant(scheduled.toInstant(), scheduled.getTimeZone().toZoneId());
            }
        } else if (this.extendedCronTab != null) {
            return this.extendedCronTab.previous();
        }
        return null;
    }

    @CheckForNull
    @SuppressRestrictedWarnings(value={CronTabList.class})
    public ZonedDateTime next() {
        if (this.cronTabList != null) {
            Calendar scheduled = this.cronTabList.next();
            if (scheduled != null) {
                return ZonedDateTime.ofInstant(scheduled.toInstant(), scheduled.getTimeZone().toZoneId());
            }
        } else if (this.extendedCronTab != null) {
            return this.extendedCronTab.next();
        }
        return null;
    }

    @CheckForNull
    public ZonedDateTime ceil(long timeInMillis) {
        if (this.cronTab != null) {
            Calendar scheduled = this.cronTab.ceil(timeInMillis);
            return ZonedDateTime.ofInstant(scheduled.toInstant(), scheduled.getTimeZone().toZoneId());
        }
        if (this.extendedCronTab != null) {
            return this.extendedCronTab.ceil(timeInMillis);
        }
        return null;
    }

    @CheckForNull
    public ZonedDateTime floor(long timeInMillis) {
        if (this.cronTab != null) {
            Calendar scheduled = this.cronTab.floor(timeInMillis);
            return ZonedDateTime.ofInstant(scheduled.toInstant(), scheduled.getTimeZone().toZoneId());
        }
        if (this.extendedCronTab != null) {
            return this.extendedCronTab.floor(timeInMillis);
        }
        return null;
    }

    @CheckForNull
    public String checkSanity() {
        if (this.cronTabList != null) {
            return this.cronTabList.checkSanity();
        }
        return null;
    }
}

