/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jenkins.plugins.explain_error.BaseAIService;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.time.Duration;

public class OpenAIService
extends BaseAIService {
    public OpenAIService(GlobalConfigurationImpl config) {
        super(config);
    }

    @Override
    protected HttpRequest buildHttpRequest(HttpRequest.Builder requestBuilder, String requestBody) {
        return requestBuilder.timeout(Duration.ofSeconds(60L)).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.config.getApiKey().getPlainText()).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
    }

    @Override
    protected String buildRequestBody(String prompt) throws IOException {
        ObjectNode requestJson = MAPPER.createObjectNode();
        requestJson.put("model", this.config.getModel());
        requestJson.put("max_tokens", 1000);
        requestJson.put("temperature", 0.3);
        ArrayNode messages = MAPPER.createArrayNode();
        ObjectNode message = MAPPER.createObjectNode();
        message.put("role", "user");
        message.put("content", prompt);
        messages.add((JsonNode)message);
        requestJson.set("messages", (JsonNode)messages);
        return MAPPER.writeValueAsString((Object)requestJson);
    }

    @Override
    protected String parseResponse(String responseBody) throws IOException {
        try {
            JsonNode errorMessage;
            JsonNode content;
            JsonNode firstChoice;
            JsonNode message;
            JsonNode jsonNode = MAPPER.readTree(responseBody);
            JsonNode choices = jsonNode.get("choices");
            if (choices != null && choices.isArray() && choices.size() > 0 && (message = (firstChoice = choices.get(0)).get("message")) != null && (content = message.get("content")) != null && !content.isNull()) {
                return content.asText().trim();
            }
            JsonNode error = jsonNode.get("error");
            if (error != null && (errorMessage = error.get("message")) != null) {
                return "AI API Error: " + errorMessage.asText();
            }
            return "Unable to parse AI response. Response: " + responseBody;
        }
        catch (Exception e) {
            LOGGER.severe("Failed to parse AI response: " + e.getMessage());
            return "Failed to parse AI response: " + e.getMessage();
        }
    }
}

