/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jenkins.plugins.explain_error.BaseAIService;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Duration;

public class GeminiService
extends BaseAIService {
    public GeminiService(GlobalConfigurationImpl config) {
        super(config);
    }

    @Override
    protected HttpRequest buildHttpRequest(HttpRequest.Builder requestBuilder, String requestBody) {
        String apiKey = this.config.getApiKey().getPlainText();
        Object url = this.getApiUrl();
        if (!((String)url).contains("key=")) {
            url = (String)url + (((String)url).contains("?") ? "&" : "?") + "key=" + apiKey;
        }
        return HttpRequest.newBuilder(URI.create((String)url)).timeout(Duration.ofSeconds(60L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
    }

    @Override
    protected String buildRequestBody(String prompt) throws IOException {
        ObjectNode requestJson = MAPPER.createObjectNode();
        ArrayNode contents = MAPPER.createArrayNode();
        ObjectNode content = MAPPER.createObjectNode();
        ArrayNode parts = MAPPER.createArrayNode();
        ObjectNode part = MAPPER.createObjectNode();
        part.put("text", prompt);
        parts.add((JsonNode)part);
        content.set("parts", (JsonNode)parts);
        contents.add((JsonNode)content);
        requestJson.set("contents", (JsonNode)contents);
        ObjectNode generationConfig = MAPPER.createObjectNode();
        generationConfig.put("temperature", 0.3);
        generationConfig.put("maxOutputTokens", 1000);
        requestJson.set("generationConfig", (JsonNode)generationConfig);
        return MAPPER.writeValueAsString((Object)requestJson);
    }

    @Override
    protected String parseResponse(String responseBody) throws IOException {
        try {
            JsonNode firstPart;
            JsonNode text;
            JsonNode parts;
            JsonNode firstCandidate;
            JsonNode content;
            JsonNode jsonNode = MAPPER.readTree(responseBody);
            JsonNode error = jsonNode.get("error");
            if (error != null) {
                JsonNode errorMessage = error.get("message");
                if (errorMessage != null) {
                    return "AI API Error: " + errorMessage.asText();
                }
                return "AI API Error: " + error.toString();
            }
            JsonNode candidates = jsonNode.get("candidates");
            if (candidates != null && candidates.isArray() && candidates.size() > 0 && (content = (firstCandidate = candidates.get(0)).get("content")) != null && (parts = content.get("parts")) != null && parts.isArray() && parts.size() > 0 && (text = (firstPart = parts.get(0)).get("text")) != null && !text.isNull()) {
                return text.asText().trim();
            }
            return "Unable to parse Gemini response. Response: " + responseBody;
        }
        catch (Exception e) {
            LOGGER.severe("Failed to parse Gemini response: " + e.getMessage());
            return "Failed to parse Gemini response: " + e.getMessage();
        }
    }
}

