/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.ProxyConfiguration;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseAIService {
    protected static final Logger LOGGER = Logger.getLogger(BaseAIService.class.getName());
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected final GlobalConfigurationImpl config;

    public BaseAIService(GlobalConfigurationImpl config) {
        this.config = config;
    }

    public String explainError(String errorLogs) throws IOException {
        if (StringUtils.isBlank((CharSequence)errorLogs)) {
            return "No error logs provided for explanation.";
        }
        String prompt = this.buildPrompt(errorLogs);
        String requestBody = this.buildRequestBody(prompt);
        try {
            URI apiUri = URI.create(this.getApiUrl());
            HttpRequest.Builder requestBuilder = ProxyConfiguration.newHttpRequestBuilder((URI)apiUri);
            HttpRequest request = this.buildHttpRequest(requestBuilder, requestBody);
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = response.body();
            LOGGER.fine("Response body length: " + responseBody.length());
            LOGGER.fine("Response body preview: " + responseBody.substring(0, Math.min(500, responseBody.length())));
            if (response.statusCode() != 200) {
                LOGGER.severe("AI API request failed with status " + response.statusCode() + ": " + responseBody);
                return "Failed to get explanation from AI service. Status: " + response.statusCode() + ". Please check your API configuration and key.";
            }
            return this.parseResponse(responseBody);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.severe("AI API request was interrupted: " + e.getMessage());
            return "Request was interrupted: " + e.getMessage();
        }
        catch (Exception e) {
            LOGGER.severe("AI API request failed: " + e.getMessage());
            return "Failed to communicate with AI service: " + e.getMessage();
        }
    }

    protected String buildPrompt(String errorLogs) {
        return "You are an expert Jenkins administrator and software engineer. Please analyze the following Jenkins build error logs and provide a clear, actionable explanation of what went wrong and how to fix it:\n\nERROR LOGS:\n" + errorLogs + "\n\nPlease provide:\n1. A summary of what caused the error\n2. Specific steps to resolve the issue\n3. Any relevant best practices to prevent similar issues\n\nKeep your response concise and focused on actionable solutions. Use plain text formatting only - no markdown, bold text, italic text, or special symbols for formatting.";
    }

    protected String getApiUrl() {
        String url = this.config.getApiUrl();
        if (url.contains("{model}")) {
            url = url.replace("{model}", this.config.getModel());
        }
        return url;
    }

    protected abstract HttpRequest buildHttpRequest(HttpRequest.Builder var1, String var2);

    protected abstract String buildRequestBody(String var1) throws IOException;

    protected abstract String parseResponse(String var1) throws IOException;
}

