/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ItemGroup;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ExplainErrorFolderProperty
extends AbstractFolderProperty<AbstractFolder<?>> {
    private BaseAIProvider aiProvider;
    private boolean enableExplanation = true;

    @DataBoundConstructor
    public ExplainErrorFolderProperty() {
    }

    @CheckForNull
    public BaseAIProvider getAiProvider() {
        return this.aiProvider;
    }

    @DataBoundSetter
    public void setAiProvider(BaseAIProvider aiProvider) {
        this.aiProvider = aiProvider;
    }

    public boolean isEnableExplanation() {
        return this.enableExplanation;
    }

    @DataBoundSetter
    public void setEnableExplanation(boolean enableExplanation) {
        this.enableExplanation = enableExplanation;
        if (!enableExplanation) {
            this.aiProvider = null;
        }
    }

    @CheckForNull
    public static BaseAIProvider findFolderProvider(@CheckForNull ItemGroup<?> itemGroup) {
        if (itemGroup == null) {
            return null;
        }
        if (itemGroup instanceof AbstractFolder) {
            BaseAIProvider provider;
            AbstractFolder folder = (AbstractFolder)itemGroup;
            ExplainErrorFolderProperty property = (ExplainErrorFolderProperty)folder.getProperties().get(ExplainErrorFolderProperty.class);
            if (property != null && (provider = property.getAiProvider()) != null) {
                if (property.isEnableExplanation()) {
                    return provider;
                }
                return null;
            }
            return ExplainErrorFolderProperty.findFolderProvider(folder.getParent());
        }
        return null;
    }

    public static boolean isFolderExplanationEnabled(@CheckForNull ItemGroup<?> itemGroup) {
        AbstractFolder folder;
        ExplainErrorFolderProperty property;
        if (itemGroup == null) {
            return true;
        }
        if (itemGroup instanceof AbstractFolder && (property = (ExplainErrorFolderProperty)(folder = (AbstractFolder)itemGroup).getProperties().get(ExplainErrorFolderProperty.class)) != null) {
            return property.isEnableExplanation();
        }
        if (itemGroup instanceof AbstractFolder) {
            return ExplainErrorFolderProperty.isFolderExplanationEnabled(((AbstractFolder)itemGroup).getParent());
        }
        return true;
    }

    @Extension
    @Symbol(value={"explainErrorFolder"})
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Explain Error Configuration";
        }
    }
}

