/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleNote;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineLogExtractor {
    private static final Logger LOGGER = Logger.getLogger(PipelineLogExtractor.class.getName());
    public static final String URL_NAME = "stages";
    private boolean isGraphViewPluginAvailable = false;
    private transient String url;
    private transient Run<?, ?> run;
    private int maxLines;

    private List<String> readLimitedLog(AnnotatedLargeText<? extends FlowNode> logText, int maxLines) {
        StringWriter writer = new StringWriter();
        try {
            String line;
            long offset = logText.writeLogTo(0L, (Writer)writer);
            if (offset <= 0L) {
                return Collections.emptyList();
            }
            String cleanLog = ConsoleNote.removeNotes((String)writer.toString());
            BufferedReader reader = new BufferedReader(new StringReader(cleanLog));
            LinkedList<String> queue = new LinkedList<String>();
            while ((line = reader.readLine()) != null) {
                if (queue.size() >= maxLines) {
                    queue.removeFirst();
                }
                queue.add(line);
            }
            return new ArrayList<String>(queue);
        }
        catch (IOException e) {
            LOGGER.severe("Unable to serialize the flow node log: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<String> getFailedStepLog() throws IOException {
        if (this.run instanceof WorkflowRun) {
            FlowExecution execution = ((WorkflowRun)this.run).getExecution();
            FlowGraphWalker walker = new FlowGraphWalker(execution);
            for (FlowNode node : walker) {
                AnnotatedLargeText logText;
                List<String> result;
                LogAction logAction;
                FlowNode nodeThatThrewException;
                ErrorAction errorAction = (ErrorAction)node.getAction(ErrorAction.class);
                if (errorAction == null || (nodeThatThrewException = ErrorAction.findOrigin((Throwable)errorAction.getError(), (FlowExecution)execution)) == null || (logAction = (LogAction)nodeThatThrewException.getAction(LogAction.class)) == null || (result = this.readLimitedLog((AnnotatedLargeText<? extends FlowNode>)(logText = logAction.getLogText()), this.maxLines)) == null || result.isEmpty()) continue;
                this.setUrl(nodeThatThrewException.getId());
                return result;
            }
        }
        this.setUrl("0");
        return this.run.getLog(this.maxLines);
    }

    private void setUrl(String node) {
        String rootUrl = Jenkins.get().getRootUrl();
        this.url = this.isGraphViewPluginAvailable ? rootUrl + this.run.getUrl() + "stages?selected-node=" + node : rootUrl + this.run.getUrl() + "console";
    }

    public String getUrl() {
        return this.url;
    }

    public PipelineLogExtractor(Run<?, ?> run, int maxLines) {
        this.run = run;
        this.maxLines = maxLines;
        if (Jenkins.get().getPlugin("pipeline-graph-view") != null) {
            this.isGraphViewPluginAvailable = true;
        }
    }
}

