/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.rest.v30.client.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Comment {
    private static final String REQUESTED_SERVICE_COMMENT_EVENT = "event";
    private static final String REQUESTED_SERVICE_COMMENT_TEXT = "text";
    private static final String REQUESTED_SERVICE_COMMENT_AUTHOR = "author";
    private static final String REQUESTED_SERVICE_COMMENT_DATE = "date";
    private static final String REQUESTED_SERVICE_COMMENT_AUTHOR_DEFAULT = "SYSTEM";
    private static final String UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DATE_TIME_PATTERN = "yyyy/MM/dd HH:mm:ss z";
    private final String event;
    private final String text;
    private final String author;
    private final String date;

    public Comment(JSONObject comment) throws JSONException {
        this.event = this.getDefaultString(comment, REQUESTED_SERVICE_COMMENT_EVENT, null);
        this.text = this.getDefaultString(comment, REQUESTED_SERVICE_COMMENT_TEXT, null);
        this.author = this.getDefaultString(comment, REQUESTED_SERVICE_COMMENT_AUTHOR, REQUESTED_SERVICE_COMMENT_AUTHOR_DEFAULT);
        this.date = this.formatDate(this.getDefaultString(comment, REQUESTED_SERVICE_COMMENT_DATE, null));
    }

    private String getDefaultString(JSONObject obj, String key, String defaultValue) throws JSONException {
        return obj.isNull(key) ? defaultValue : obj.getString(key);
    }

    private String formatDate(String dateStr) {
        if (dateStr != null) {
            try {
                SimpleDateFormat inputFormat = new SimpleDateFormat(UTC_DATE_FORMAT);
                inputFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date convertedDate = inputFormat.parse(dateStr);
                SimpleDateFormat outputFormat = new SimpleDateFormat(DATE_TIME_PATTERN);
                outputFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                return outputFormat.format(convertedDate);
            }
            catch (ParseException e) {
                System.err.println(e);
            }
        }
        return dateStr;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.author);
        builder.append(" at ");
        builder.append(this.date);
        if (StringUtils.isNotBlank((String)this.event)) {
            builder.append(" - ");
            builder.append(this.event);
        }
        if (StringUtils.isNotBlank((String)this.text)) {
            builder.append(" - ");
            builder.append(this.text);
        }
        return builder.toString();
    }
}

