/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.plugin.actions;

import com.embotics.vlm.plugin.Messages;
import com.embotics.vlm.plugin.VCommanderAction;
import com.embotics.vlm.plugin.VCommanderConfig;
import com.embotics.vlm.plugin.actions.AbstractVCommanderAction;
import com.embotics.vlm.plugin.actions.PluginUtils;
import com.embotics.vlm.rest.v30.client.VCommanderClient;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import com.embotics.vlm.rest.v30.client.model.WorkflowTargetType;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class VCommanderRunWorkflowAction
extends AbstractVCommanderAction {
    static final String ENV_VARIABLE_WORKFLOW_TASK_ID = "VCOMMANDER_WORKFLOW_TASK_ID";
    private final String targetType;
    private final String targetName;
    private final String workflowName;
    @Extension(ordinal=156.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VCommanderRunWorkflowAction(String targetType, String targetName, String workflowName, Boolean sync, Long timeout, Long polling) {
        super(sync, timeout, polling);
        this.targetType = targetType;
        this.targetName = targetName;
        this.workflowName = workflowName;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Run<?, ?> run, TaskListener listener) throws InterruptedException, IOException {
        if (StringUtils.isBlank((String)this.workflowName)) {
            throw new VCommanderException("There is no configuration for the vCommander workflow build step.");
        }
        listener.getLogger().println(client.getClientInfo());
        try (VCommanderClient client = VCommanderConfig.getVCommanderClient();){
            String taskId;
            Long workflowDefinitionId;
            try {
                listener.getLogger().println("Looking up command workflow with name: '" + this.workflowName + "'");
                workflowDefinitionId = client.getWorkflowDefinition(this.workflowName);
            }
            catch (JSONException e) {
                throw new VCommanderException(e, "Error while retrieving workflow from vCommander.");
            }
            try {
                String resolvedTargetName = Util.replaceMacro((String)this.targetName, (Map)run.getEnvironment(listener));
                String resolvedTargetType = Util.replaceMacro((String)this.targetType, (Map)run.getEnvironment(listener));
                listener.getLogger().println("Running command workflow: '" + this.workflowName + "' for target: '" + resolvedTargetName + "' with type: " + resolvedTargetType);
                taskId = client.runCommandWorkflow(workflowDefinitionId, resolvedTargetType, resolvedTargetName);
                listener.getLogger().println("Command workflow submitted to vCommander. Task ID: " + taskId);
                PluginUtils.addEnvVariable(run, listener, ENV_VARIABLE_WORKFLOW_TASK_ID, taskId);
            }
            catch (JSONException e) {
                throw new VCommanderException(e, "Error while running command workflow in vCommander.");
            }
            if (this.getSync().booleanValue()) {
                VCommanderRunWorkflowAction.waitForWorkflowToBeCompleted(client, taskId, this.getTimeout(), this.getPolling(), run, listener);
            }
        }
    }

    static void waitForWorkflowToBeCompleted(VCommanderClient client, String taskId, long timeout, long polling, Run<?, ?> run, TaskListener listener) throws VCommanderException, InterruptedException {
        try {
            listener.getLogger().println("Waiting " + timeout + " minutes for workflow completion. Checking every " + polling + " seconds ...");
            client.waitForWorkflowToBeCompleted(taskId, timeout, polling, listener.getLogger());
            listener.getLogger().println("Workflow successfully completed.");
        }
        catch (JSONException e) {
            throw new VCommanderException(e, "Error while waiting for workflow completion.");
        }
    }

    public Descriptor<VCommanderAction> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends AbstractVCommanderAction.AbstractVCommanderActionDescriptor {
        public String getDisplayName() {
            return Messages.VCommanderRunWorkflowAction_displayName();
        }

        public ComboBoxModel doFillTargetTypeItems() {
            ComboBoxModel items = new ComboBoxModel();
            for (WorkflowTargetType type : WorkflowTargetType.values()) {
                items.add((Object)type.name());
            }
            return items;
        }

        public FormValidation doCheckTargetType(@QueryParameter String targetType) throws IOException, ServletException {
            if (StringUtils.isBlank((String)targetType)) {
                return FormValidation.ok();
            }
            if (!PluginUtils.hasVariable(targetType) && !this.isTargetTypeValid(targetType)) {
                return FormValidation.error((String)Messages.VCommanderRunWorkflowAction_errors_targetTypeInvalid(targetType));
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public FormValidation doCheckWorkflowName(@QueryParameter String targetType, @QueryParameter String workflowName) throws IOException, ServletException {
            block12: {
                if (StringUtils.isBlank((String)workflowName)) {
                    return FormValidation.ok();
                }
                try (VCommanderClient client = VCommanderConfig.getVCommanderClient();){
                    Long workflowDefinitionId;
                    try {
                        workflowDefinitionId = client.getWorkflowDefinition(workflowName);
                    }
                    catch (Exception e) {
                        if (e.getCause() != null && e.getCause() instanceof ConnectException) {
                            FormValidation formValidation = FormValidation.error((String)Messages.VCommanderConfig_connection_failedConnection());
                            client.close();
                            return formValidation;
                        }
                        FormValidation formValidation = FormValidation.error((String)e.getMessage());
                        client.close();
                        return formValidation;
                    }
                    String workflowTargetType = client.getWorkflowDefinitionTargetType(workflowDefinitionId);
                    if (StringUtils.isBlank((String)targetType) || !PluginUtils.hasVariable(targetType) && (!this.isTargetTypeValid(targetType) || !"ALL".equals(workflowTargetType) && !targetType.equals(workflowTargetType))) {
                        String displayWorkflowTargetType = "ALL".equals(workflowTargetType) ? Messages.VCommanderRunWorkflowAction_targetType_ALL() : workflowTargetType;
                        FormValidation formValidation = FormValidation.error((String)Messages.VCommanderRunWorkflowAction_errors_targetTypeDoNotMatch(targetType, displayWorkflowTargetType));
                        return formValidation;
                    }
                    break block12;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            return FormValidation.ok();
        }

        private boolean isTargetTypeValid(String resolvedTargetType) {
            try {
                WorkflowTargetType.valueOf(resolvedTargetType);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

