/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.plugin.actions;

import com.embotics.vlm.plugin.Messages;
import com.embotics.vlm.plugin.VCommanderAction;
import com.embotics.vlm.plugin.VCommanderConfig;
import com.embotics.vlm.plugin.actions.AbstractVCommanderAction;
import com.embotics.vlm.plugin.actions.PluginUtils;
import com.embotics.vlm.rest.v30.client.VCommanderClient;
import com.embotics.vlm.rest.v30.client.model.DeployedComponentInfo;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class VCommanderRequestNewServiceAction
extends AbstractVCommanderAction {
    static final String ENV_VARIABLE_REQUEST_ID = "VCOMMANDER_REQUESTED_SERVICE_ID";
    static final String VCOMMANDER_REQUESTED_SERVICE_COMPONENT_NAME_FORMAT = "VCOMMANDER_REQUESTED_SERVICE%d_COMPONENT%d_NAME";
    static final String VCOMMANDER_REQUESTED_SERVICE_COMPONENT_TYPE_FORMAT = "VCOMMANDER_REQUESTED_SERVICE%d_COMPONENT%d_TYPE";
    private final String serviceName;
    private final String payload;
    @Extension(ordinal=166.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VCommanderRequestNewServiceAction(String payload, Boolean sync, Long timeout, Long polling) {
        super(sync, timeout, polling);
        this.payload = payload;
        this.serviceName = this.getDefaultServiceName(payload);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPayload() {
        return this.payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultServiceName(String payload) {
        try (VCommanderClient client = null;){
            client = VCommanderConfig.getVCommanderClient();
            String string = client.getPublishedServiceNameByPayload(payload);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Run<?, ?> run, TaskListener listener) throws InterruptedException, IOException {
        if (StringUtils.isBlank((String)this.payload)) {
            throw new VCommanderException("There is no configuration for the vCommander service request build step.");
        }
        try {
            new JSONObject(this.payload);
        }
        catch (JSONException e) {
            throw new VCommanderException(e, "Error in build step configuration. Payload is not in valid JSON format.");
        }
        listener.getLogger().println(client.getClientInfo());
        try (VCommanderClient client = VCommanderConfig.getVCommanderClient();){
            Long requestId;
            try {
                String resolvedPayload = Util.replaceMacro((String)this.payload, (Map)run.getEnvironment(listener));
                listener.getLogger().println("Creating new service request with payload: " + resolvedPayload);
                requestId = client.requestService(resolvedPayload);
                PluginUtils.addEnvVariable(run, listener, ENV_VARIABLE_REQUEST_ID, requestId.toString());
                listener.getLogger().println("Service was succesfuly requested. RequestID: " + requestId);
            }
            catch (JSONException e) {
                throw new VCommanderException(e, "Error while requesting service request from vCommander.");
            }
            if (this.getSync().booleanValue()) {
                VCommanderRequestNewServiceAction.waitForServiceRequestToBeCompleted(client, requestId, this.getTimeout(), this.getPolling(), run, listener);
            }
        }
    }

    static void waitForServiceRequestToBeCompleted(VCommanderClient client, Long requestId, long timeout, long polling, Run<?, ?> run, TaskListener listener) throws VCommanderException, InterruptedException {
        try {
            listener.getLogger().println("Waiting " + timeout + " minutes for request completion. Checking every " + polling + " seconds ...");
            List<DeployedComponentInfo> deployedComponents = client.waitForServiceRequestToBeCompleted(requestId, timeout, polling, listener.getLogger());
            listener.getLogger().println("Service request successfully completed.");
            for (DeployedComponentInfo deployedComponent : deployedComponents) {
                String nameEnvVarKey = String.format(VCOMMANDER_REQUESTED_SERVICE_COMPONENT_NAME_FORMAT, deployedComponent.getServiceIndex(), deployedComponent.getComponentIndex());
                PluginUtils.addEnvVariable(run, listener, nameEnvVarKey, deployedComponent.getComponentName());
                String typeEnvVarKey = String.format(VCOMMANDER_REQUESTED_SERVICE_COMPONENT_TYPE_FORMAT, deployedComponent.getServiceIndex(), deployedComponent.getComponentIndex());
                PluginUtils.addEnvVariable(run, listener, typeEnvVarKey, deployedComponent.getComponentType());
            }
        }
        catch (JSONException e) {
            throw new VCommanderException(e, "Error while waiting for request completion.");
        }
    }

    public Descriptor<VCommanderAction> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends AbstractVCommanderAction.AbstractVCommanderActionDescriptor {
        public String getDisplayName() {
            return Messages.VCommanderRequestNewServiceAction_displayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JavaScriptMethod
        public String getPayload(String serviceName) throws IOException, ServletException {
            try (VCommanderClient client = VCommanderConfig.getVCommanderClient();){
                Long publishedServiceId = client.getPublishedService(serviceName);
                String string = client.getServiceRequestPayload(publishedServiceId);
                return string;
            }
        }

        public FormValidation doCheckPayload(@QueryParameter String payload) throws IOException, ServletException {
            if (StringUtils.isBlank((String)payload)) {
                return FormValidation.ok();
            }
            try {
                new JSONObject(payload);
                return FormValidation.ok();
            }
            catch (JSONException e) {
                return FormValidation.error((String)Messages.VCommanderRequestNewServiceAction_errors_payloadFormat(e.getMessage()));
            }
        }
    }
}

