/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.plugin.actions;

import com.embotics.vlm.plugin.VCommanderEnvironmentContributingAction;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class PluginUtils {
    static void addEnvVariable(Run<?, ?> run, TaskListener listener, String key, String value) {
        listener.getLogger().println("Adding new environment variable: " + key + "=" + value);
        VCommanderEnvironmentContributingAction contributorAction = (VCommanderEnvironmentContributingAction)run.getAction(VCommanderEnvironmentContributingAction.class);
        if (contributorAction == null) {
            contributorAction = new VCommanderEnvironmentContributingAction();
            run.addAction((Action)contributorAction);
        }
        contributorAction.add(key, value);
    }

    static boolean isNumericOrVariable(String value) {
        return StringUtils.isNotBlank((String)value) && (PluginUtils.hasVariable(value) || NumberUtils.isDigits((String)value));
    }

    static boolean hasVariable(String input) {
        VariableChecker resolver = new VariableChecker();
        Util.replaceMacro((String)input, (VariableResolver)resolver);
        return resolver.wasCalled();
    }

    private static class VariableChecker
    implements VariableResolver<String> {
        boolean called = false;

        private VariableChecker() {
        }

        public String resolve(String name) {
            this.called = true;
            return null;
        }

        public boolean wasCalled() {
            return this.called;
        }
    }
}

