/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.plugin;

import com.embotics.vlm.plugin.Messages;
import com.embotics.vlm.plugin.VCommanderAction;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class VCommanderBuilder
extends Builder
implements SimpleBuildStep {
    private static final String PROPERTY_ACTION = "action";
    private final VCommanderAction action;

    @DataBoundConstructor
    public VCommanderBuilder(VCommanderAction action) {
        this.action = action;
    }

    public VCommanderAction getAction() {
        return this.action;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println();
        listener.getLogger().println("========== Starting vCommander build step: " + this.action.getDescriptor().getDisplayName() + " ==========");
        try {
            this.action.perform(run, listener);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof ConnectException) {
                throw new VCommanderException(Messages.VCommanderConfig_connection_failedConnection());
            }
            throw e;
        }
        listener.getLogger().println("========== Finished vCommander build step: " + this.action.getDescriptor().getDisplayName() + " ==========");
        listener.getLogger().println();
    }

    @Extension
    @Symbol(value={"vCommander"})
    public static final class VCommanderBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public VCommanderBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            VCommanderAction action = VCommanderBuilderDescriptor.bindJSONWithDescriptor(req, formData, VCommanderBuilder.PROPERTY_ACTION, VCommanderAction.class);
            return new VCommanderBuilder(action);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.VCommanderBuilder_displayName();
        }

        public List<Descriptor<VCommanderAction>> getActions() {
            Jenkins jenkinsInstance = Jenkins.getInstance();
            return jenkinsInstance != null ? jenkinsInstance.getDescriptorList(VCommanderAction.class) : Collections.emptyList();
        }

        private static <T> T bindJSONWithDescriptor(StaplerRequest req, JSONObject formData, String fieldName, Class<T> expectedClazz) throws Descriptor.FormException {
            if ((formData = formData.getJSONObject(fieldName)) == null || formData.isNullObject()) {
                return null;
            }
            String clazzName = formData.optString("$class", null);
            if (clazzName == null) {
                clazzName = formData.optString("stapler-class", null);
            }
            if (clazzName == null) {
                throw new Descriptor.FormException("No $class or stapler-class is specified", fieldName);
            }
            try {
                Jenkins jenkinsInstance = Jenkins.getInstance();
                if (jenkinsInstance == null) {
                    return null;
                }
                Class<?> clazz = jenkinsInstance.getPluginManager().uberClassLoader.loadClass(clazzName);
                Descriptor d = jenkinsInstance.getDescriptorOrDie(clazz);
                Describable ret = d.newInstance(req, formData);
                return (T)ret;
            }
            catch (ClassNotFoundException e) {
                throw new Descriptor.FormException(String.format("Failed to instantiate: class not found %s", clazzName), (Throwable)e, fieldName);
            }
            catch (ClassCastException e) {
                throw new Descriptor.FormException(String.format("Failed to instantiate: instantiated as %s but expected %s", clazzName, expectedClazz.getName()), (Throwable)e, fieldName);
            }
        }
    }
}

