/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import com.fasterxml.jackson.databind.JsonNode;

public class DiversionRepository {
    private final String id;
    private final String name;
    private final String description;
    private final String defaultBranch;

    public DiversionRepository(JsonNode json) {
        this.id = json.get("repo_id").asText();
        this.name = json.get("repo_name").asText();
        this.description = json.has("description") ? json.get("description").asText() : "";
        this.defaultBranch = json.has("default_branch_id") ? json.get("default_branch_id").asText() : "main";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public String toString() {
        return "DiversionRepository{id='" + this.id + "', name='" + this.name + "', description='" + this.description + "', defaultBranch='" + this.defaultBranch + "'}";
    }
}

