/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import hudson.model.Run;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import io.superstudios.plugins.diversion.DiversionAuthor;
import io.superstudios.plugins.diversion.DiversionChangeLogEntry;
import io.superstudios.plugins.diversion.DiversionChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DiversionChangeLogParser
extends ChangeLogParser {
    public ChangeLogSet<? extends ChangeLogSet.Entry> parse(Run build, RepositoryBrowser browser, File changelogFile) throws IOException {
        ArrayList<DiversionChangeLogEntry> entries = new ArrayList<DiversionChangeLogEntry>();
        if (changelogFile == null || !changelogFile.exists()) {
            return new DiversionChangeLogSet(build, entries);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(changelogFile);
            NodeList entryNodes = doc.getElementsByTagName("entry");
            for (int i = 0; i < entryNodes.getLength(); ++i) {
                Element entryElement = (Element)entryNodes.item(i);
                String commitId = this.getElementText(entryElement, "commitId");
                String msg = this.getElementText(entryElement, "msg");
                String authorName = this.getElementText(entryElement, "author");
                String timestampStr = this.getElementText(entryElement, "timestamp");
                long timestamp = 0L;
                try {
                    timestamp = Long.parseLong(timestampStr);
                }
                catch (NumberFormatException e) {
                    timestamp = System.currentTimeMillis() / 1000L;
                }
                ArrayList<String> affectedPaths = new ArrayList<String>();
                NodeList fileNodes = entryElement.getElementsByTagName("file");
                for (int j = 0; j < fileNodes.getLength(); ++j) {
                    String filePath = fileNodes.item(j).getTextContent();
                    if (filePath == null || filePath.trim().isEmpty()) continue;
                    affectedPaths.add(filePath.trim());
                }
                DiversionAuthor author = new DiversionAuthor();
                author.setName(authorName);
                author.setEmail("");
                author.setFullName(authorName);
                author.setId("");
                DiversionChangeLogEntry entry = new DiversionChangeLogEntry(commitId, msg, author, timestamp, affectedPaths);
                entries.add(entry);
            }
            DiversionChangeLogSet changeLogSet = new DiversionChangeLogSet(build, entries);
            for (DiversionChangeLogEntry entry : entries) {
                entry.setParentSet(changeLogSet);
            }
            return changeLogSet;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            System.err.println("Error parsing changelog: " + e.getMessage());
            e.printStackTrace();
            return new DiversionChangeLogSet(build, entries);
        }
    }

    private String getElementText(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return "";
    }
}

