/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import com.fasterxml.jackson.databind.JsonNode;
import io.superstudios.plugins.diversion.DiversionAuthor;

public class DiversionTag {
    private String id;
    private String name;
    private String commitId;
    private String description;
    private DiversionAuthor author;
    private long time;

    public DiversionTag(JsonNode node) {
        this.id = node.has("id") ? node.get("id").asText() : null;
        this.name = node.has("name") ? node.get("name").asText() : null;
        this.commitId = node.has("commit_id") ? node.get("commit_id").asText() : null;
        this.description = node.has("description") ? node.get("description").asText() : null;
        long l = this.time = node.has("time") ? node.get("time").asLong() : 0L;
        if (node.has("author") && !node.get("author").isNull()) {
            this.author = new DiversionAuthor(node.get("author"));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getDescription() {
        return this.description;
    }

    public DiversionAuthor getAuthor() {
        return this.author;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return "DiversionTag{id='" + this.id + "', name='" + this.name + "', commitId='" + this.commitId + "', description='" + this.description + "', author=" + String.valueOf(this.author) + ", time=" + this.time + "}";
    }
}

