/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import io.superstudios.plugins.diversion.DiversionAuthor;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class DiversionChangeLogEntry
extends ChangeLogSet.Entry {
    private final String commitId;
    private final String message;
    private final DiversionAuthor author;
    private final long timestamp;
    private final Collection<String> affectedPaths;

    public DiversionChangeLogEntry(String commitId, String message, DiversionAuthor author, long timestamp) {
        this.commitId = commitId;
        this.message = message;
        this.author = author;
        this.timestamp = timestamp;
        this.affectedPaths = Collections.emptyList();
    }

    public DiversionChangeLogEntry(String commitId, String message, DiversionAuthor author, long timestamp, Collection<String> affectedPaths) {
        this.commitId = commitId;
        this.message = message;
        this.author = author;
        this.timestamp = timestamp;
        this.affectedPaths = affectedPaths != null ? affectedPaths : Collections.emptyList();
    }

    public String getMsg() {
        return this.message;
    }

    public User getAuthor() {
        if (this.author != null && this.author.getName() != null) {
            return User.get((String)this.author.getName(), (boolean)true);
        }
        return User.getUnknown();
    }

    public String getCommitId() {
        return this.commitId;
    }

    public DiversionAuthor getDiversionAuthor() {
        return this.author;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Date getDate() {
        return new Date(this.timestamp * 1000L);
    }

    public String toString() {
        return this.commitId + ": " + this.message;
    }

    public String getDisplayName() {
        if (this.commitId != null && !this.commitId.isEmpty()) {
            return this.commitId + " \u2014 " + this.message;
        }
        return this.message;
    }

    public String getMsgAnnotated() {
        if (this.commitId != null && !this.commitId.isEmpty()) {
            return this.commitId + " \u2014 " + this.message;
        }
        return this.message;
    }

    public Collection<String> getAffectedPaths() {
        return this.affectedPaths;
    }

    void setParentSet(ChangeLogSet<? extends ChangeLogSet.Entry> parent) {
        this.setParent(parent);
    }
}

