/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.deepsecurity.smartcheck.workflow;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.trendmicro.deepsecurity.smartcheck.Messages;
import com.trendmicro.deepsecurity.smartcheck.SmartCheckAction;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.ArtifactArchiver;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SmartCheckScanStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(SmartCheckScanStep.class.getName());
    private static final String DSSC_SCAN_IMAGE = "deepsecurity/smartcheck-scan-action";
    private static final String DEFAULT_RESULTS_FILE = "scan-results.json";
    private String smartcheckHost;
    private boolean insecureSkipTLSVerify = false;
    @Deprecated
    private String smartcheckUser;
    @Deprecated
    private String smartcheckPassword;
    private String smartcheckCredentialsId;
    private String imageName;
    private String imagePullAuth;
    private boolean insecureSkipRegistryTLSVerify = false;
    private String resultsFile;
    private String findingsThreshold;
    private boolean preregistryScan = false;
    private String preregistryHost;
    @Deprecated
    private String preregistryUser;
    @Deprecated
    private String preregistryPassword;
    private String preregistryCredentialsId;
    private boolean debug = false;

    @Deprecated
    @DataBoundConstructor
    public SmartCheckScanStep(String imageName, String smartcheckHost) {
        if (StringUtils.stripToNull((String)imageName) == null) {
            throw new IllegalArgumentException("imageName cannot be empty");
        }
        if (StringUtils.stripToNull((String)smartcheckHost) == null) {
            throw new IllegalArgumentException("smartcheckHost cannot be empty");
        }
        SmartCheckAction.validateSmartcheckUrl(smartcheckHost);
        this.imageName = imageName;
        this.smartcheckHost = smartcheckHost;
    }

    public String getSmartcheckHost() {
        return this.smartcheckHost;
    }

    @DataBoundSetter
    public void setSmartCheckHost(String smartcheckHost) {
        this.smartcheckHost = smartcheckHost;
    }

    public boolean isInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    @DataBoundSetter
    public void setInsecureSkipTLSVerify(boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
    }

    @Deprecated
    public String getSmartcheckUser() {
        return this.smartcheckUser;
    }

    @Deprecated
    @DataBoundSetter
    public void setSmartcheckUser(String smartcheckUser) {
        this.smartcheckUser = smartcheckUser;
    }

    @Deprecated
    public String getSmartcheckPassword() {
        return this.smartcheckPassword;
    }

    @Deprecated
    @DataBoundSetter
    public void setSmartcheckPassword(String smartcheckPassword) {
        this.smartcheckPassword = smartcheckPassword;
    }

    public String getSmartcheckCredentialsId() {
        return this.smartcheckCredentialsId;
    }

    @DataBoundSetter
    public void setSmartcheckCredentialsId(String smartcheckCredentialsId) {
        this.smartcheckCredentialsId = smartcheckCredentialsId;
    }

    public String getImageName() {
        return this.imageName;
    }

    @DataBoundSetter
    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImagePullAuth() {
        return this.imagePullAuth;
    }

    @DataBoundSetter
    public void setImagePullAuth(String imagePullAuth) {
        this.imagePullAuth = imagePullAuth;
    }

    public boolean isInsecureSkipRegistryTLSVerify() {
        return this.insecureSkipRegistryTLSVerify;
    }

    @DataBoundSetter
    public void setInsecureSkipRegistryTLSVerify(boolean insecureSkipRegistryTLSVerify) {
        this.insecureSkipRegistryTLSVerify = insecureSkipRegistryTLSVerify;
    }

    public String getResultsFile() {
        return this.resultsFile;
    }

    @DataBoundSetter
    public void setResultsFile(String resultsFile) {
        this.resultsFile = resultsFile;
    }

    public String getFindingsThreshold() {
        return this.findingsThreshold;
    }

    @DataBoundSetter
    public void setFindingsThreshold(String findingsThreshold) {
        this.findingsThreshold = findingsThreshold;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @DataBoundSetter
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isPreregistryScan() {
        return this.preregistryScan;
    }

    @DataBoundSetter
    public void setPreregistryScan(boolean preregistryEnabled) {
        this.preregistryScan = preregistryEnabled;
    }

    public String getPreregistryHost() {
        return this.preregistryHost;
    }

    @DataBoundSetter
    public void setPreregistryHost(String preregistryHost) {
        this.preregistryHost = preregistryHost;
    }

    @Deprecated
    public String getPreregistryUser() {
        return this.preregistryUser;
    }

    @Deprecated
    @DataBoundSetter
    public void setPreregistryUser(String preregistryUser) {
        this.preregistryUser = preregistryUser;
    }

    @Deprecated
    public String getPreregistryPassword() {
        return this.preregistryPassword;
    }

    @Deprecated
    @DataBoundSetter
    public void setPreregistryPassword(String preregistryPassword) {
        this.preregistryPassword = preregistryPassword;
    }

    public String getPreregistryCredentialsId() {
        return this.preregistryCredentialsId;
    }

    @DataBoundSetter
    public void setPreregistryCredentialsId(String preregistryCredentialsId) {
        this.preregistryCredentialsId = preregistryCredentialsId;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SmartCheckScanStepExecution(context, this);
    }

    public static class SmartCheckScanStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private static final int EXIT_OK = 0;
        private static final int EXIT_THRESHOLD_FAILURE = 2;
        private transient SmartCheckScanStep step;

        protected SmartCheckScanStepExecution(StepContext context, SmartCheckScanStep step) {
            super(context);
            this.step = step;
        }

        private String getURIForHost(String host) {
            try {
                URI u = new URI(host);
                if (u.getHost() != null) {
                    return host;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return "https://" + host;
        }

        private String derivePreregistryHost(String smartcheckHost) {
            try {
                URI u = new URI(this.getURIForHost(smartcheckHost));
                return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), 5000, u.getPath(), u.getQuery(), u.getFragment()).toString();
            }
            catch (URISyntaxException e) {
                return smartcheckHost;
            }
        }

        private StandardUsernamePasswordCredentials getCredentials(String credentialsId, String host, Item owner) {
            if (credentialsId == null) {
                return null;
            }
            return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.getURIForHost(host)).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        }

        private boolean addUsernamePasswordArgs(ArgumentListBuilder dockerCommandArgs, String usernameVar, String passwordVar, String credentialsId, String credentialsAttribute, String host, Run<?, ?> run, String defaultUsername, String defaultPassword, boolean required) {
            if (credentialsId != null) {
                StandardUsernamePasswordCredentials smartcheckCredentials = this.getCredentials(credentialsId, host, (Item)run.getParent());
                if (smartcheckCredentials == null) {
                    this.getContext().onFailure((Throwable)new AbortException("Could not find credentials with id " + credentialsId + " for host " + host.replace("https://", "")));
                    return false;
                }
                CredentialsProvider.track(run, (Credentials)smartcheckCredentials);
                dockerCommandArgs.add(new String[]{"-e", usernameVar + "=" + smartcheckCredentials.getUsername()});
                dockerCommandArgs.add(new String[]{"-e", passwordVar + "=" + Secret.toString((Secret)smartcheckCredentials.getPassword())});
                return true;
            }
            if (required && (defaultUsername == null || defaultPassword == null)) {
                this.getContext().onFailure((Throwable)new AbortException("Credentials are required, use " + credentialsAttribute + " to provide them."));
                return false;
            }
            if (defaultUsername != null) {
                dockerCommandArgs.add(new String[]{"-e", usernameVar + "=" + defaultUsername});
            }
            if (defaultPassword != null) {
                dockerCommandArgs.add(new String[]{"-e", passwordVar + "=" + defaultPassword});
            }
            return true;
        }

        protected Void run() throws IOException, InterruptedException {
            String errorMessage;
            String resultsFile;
            String preregistryHost;
            LOGGER.fine("Starting scan step");
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            PrintStream logger = listener.getLogger();
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            Run currentBuild = (Run)this.getContext().get(Run.class);
            FilePath workspaceFilePath = (FilePath)this.getContext().get(FilePath.class);
            if (workspaceFilePath == null) {
                this.getContext().onFailure((Throwable)new AbortException("No workspace found. Please check your pipeline script and ensure it's running within a `node` block."));
                return null;
            }
            String workspacePath = workspaceFilePath.getRemote();
            ArgumentListBuilder dockerCommandArgs = new ArgumentListBuilder();
            dockerCommandArgs.add(new String[]{"docker", "run", "-i", "--rm", "--read-only"});
            dockerCommandArgs.add(new String[]{"--cap-drop", "ALL"});
            dockerCommandArgs.add(new String[]{"-e", "DSSC_SMARTCHECK_HOST=" + this.step.getSmartcheckHost()});
            dockerCommandArgs.add(new String[]{"-e", "DSSC_IMAGE_NAME=" + this.step.getImageName()});
            if (!this.addUsernamePasswordArgs(dockerCommandArgs, "DSSC_SMARTCHECK_USER", "DSSC_SMARTCHECK_PASSWORD", this.step.getSmartcheckCredentialsId(), "smartcheckCredentialsId", this.step.getSmartcheckHost(), currentBuild, this.step.getSmartcheckUser(), this.step.getSmartcheckPassword(), true)) {
                return null;
            }
            if (this.step.isInsecureSkipTLSVerify()) {
                dockerCommandArgs.add(new String[]{"-e", "DSSC_INSECURE_SKIP_TLS_VERIFY=" + this.step.isInsecureSkipTLSVerify()});
            }
            if (this.step.isInsecureSkipRegistryTLSVerify()) {
                dockerCommandArgs.add(new String[]{"-e", "DSSC_INSECURE_SKIP_REGISTRY_TLS_VERIFY=" + this.step.isInsecureSkipRegistryTLSVerify()});
            }
            if (StringUtils.stripToNull((String)this.step.getImagePullAuth()) != null) {
                dockerCommandArgs.add(new String[]{"-e", "DSSC_IMAGE_PULL_AUTH=" + this.step.getImagePullAuth()});
            }
            if (StringUtils.stripToNull((String)this.step.getFindingsThreshold()) != null) {
                dockerCommandArgs.add(new String[]{"-e", "DSSC_FINDINGS_THRESHOLD=" + this.step.getFindingsThreshold()});
            }
            if (this.step.isPreregistryScan()) {
                dockerCommandArgs.add(new String[]{"--mount", "type=tmpfs,destination=/root/.docker"});
                dockerCommandArgs.add(new String[]{"-v", "/var/run/docker.sock:/var/run/docker.sock"});
                dockerCommandArgs.add(new String[]{"-e", "DSSC_PREREGISTRY_SCAN=true"});
            }
            if ((preregistryHost = StringUtils.stripToNull((String)this.step.getPreregistryHost())) != null) {
                dockerCommandArgs.add(new String[]{"-e", "DSSC_PREREGISTRY_HOST=" + preregistryHost});
            }
            if (!this.addUsernamePasswordArgs(dockerCommandArgs, "DSSC_PREREGISTRY_USER", "DSSC_PREREGISTRY_PASSWORD", this.step.getPreregistryCredentialsId(), "preregistryCredentialsId", preregistryHost != null ? preregistryHost : this.derivePreregistryHost(this.step.getSmartcheckHost()), currentBuild, this.step.getPreregistryUser(), this.step.getPreregistryPassword(), false)) {
                return null;
            }
            dockerCommandArgs.add(SmartCheckScanStep.DSSC_SCAN_IMAGE);
            if (this.step.isDebug()) {
                logger.println("command = " + dockerCommandArgs.toString());
            }
            logger.println("Starting Deep Security Smart Check scan...");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int status = launcher.launch().cmds(dockerCommandArgs).stderr((OutputStream)logger).stdout((OutputStream)baos).quiet(!this.step.isDebug()).join();
            String output = new String(baos.toByteArray(), "UTF-8");
            if (this.step.isDebug()) {
                logger.println("Status code was: " + status);
            }
            if (this.step.getResultsFile() != null) {
                Path normalized = Paths.get(workspacePath, this.step.getResultsFile()).normalize();
                if (!normalized.startsWith(workspacePath)) {
                    this.getContext().onFailure((Throwable)new IllegalArgumentException("Results file must be in the current workspace."));
                    return null;
                }
                resultsFile = Paths.get(workspacePath, new String[0]).relativize(normalized).toString();
            } else {
                resultsFile = SmartCheckScanStep.DEFAULT_RESULTS_FILE;
            }
            if (output.length() > 0) {
                boolean fileWritten;
                block24: {
                    fileWritten = false;
                    try {
                        workspaceFilePath.child(resultsFile).write(output, "UTF-8");
                        fileWritten = true;
                    }
                    catch (IOException e) {
                        logger.println("Failed to write results to file.");
                        if (!this.step.isDebug()) break block24;
                        logger.println(e);
                    }
                }
                if (fileWritten) {
                    block25: {
                        ArtifactArchiver artifactArchiver = new ArtifactArchiver(resultsFile);
                        if (this.step.isDebug()) {
                            logger.println(String.format("Build root directory: %s", currentBuild.getRootDir()));
                            logger.println(String.format("Workspace remote: %s", workspaceFilePath.getRemote()));
                            logger.println(String.format("Archiving artifacts: %s", artifactArchiver.getArtifacts()));
                        }
                        LOGGER.fine(String.format("Archiving artifacts: %s", artifactArchiver.getArtifacts()));
                        try {
                            artifactArchiver.perform(currentBuild, workspaceFilePath, launcher, listener);
                        }
                        catch (IOException e) {
                            logger.println("Failed to archive results file");
                            if (!this.step.isDebug()) break block25;
                            logger.println(e);
                        }
                    }
                    LOGGER.fine("Archiving complete.");
                }
            }
            if (status != 0 && status != 2) {
                errorMessage = "Deep Security Smart Check scan returned an error.";
                logger.println(errorMessage);
                logger.println(output);
                throw new AbortException(errorMessage);
            }
            currentBuild.addAction((Action)new SmartCheckAction(workspacePath, output, this.step.getSmartcheckHost()));
            if (status == 0) {
                logger.println("Scan successful");
                this.getContext().onSuccess(null);
                return null;
            }
            if (status == 2) {
                errorMessage = "Deep Security Smart Check scan found issues with the image";
                logger.println(errorMessage);
                throw new AbortException(errorMessage);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(Arrays.asList(Run.class, TaskListener.class).stream().collect(Collectors.toSet()));
        }

        public String getFunctionName() {
            return "smartcheckScan";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.SmartCheckBuilder_DescriptorImpl_DisplayName();
        }
    }
}

