/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.deepsecurity.smartcheck;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.json.JsonSanitizer;
import com.trendmicro.deepsecurity.smartcheck.model.ScanResult;
import hudson.model.Run;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import org.apache.http.client.utils.URIBuilder;

public class SmartCheckAction
implements RunAction2 {
    private static final Logger LOGGER = Logger.getLogger(SmartCheckAction.class.getName());
    private transient Run<?, ?> run;
    private ScanResult scanResult;
    private String scanUIUrl;

    public SmartCheckAction(String workspace, String resultsOutput, String smartcheckHost) {
        ScanResult scanResult;
        try {
            scanResult = this.parseScanResults(workspace, resultsOutput);
        }
        catch (BuildScanResultsException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.fine(e.getStackTrace().toString());
            return;
        }
        this.setScanResult(scanResult);
        String smartcheckUrl = SmartCheckAction.validateSmartcheckUrl(smartcheckHost);
        try {
            String uiUrl = new URIBuilder(smartcheckUrl).setPath("scans/" + this.getScanResult().getId()).build().toString();
            this.setScanUIUrl(uiUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("smartcheckHost is not a valid url");
        }
    }

    public static String validateSmartcheckUrl(String smartcheckHost) throws IllegalArgumentException {
        String smartcheckUrl = smartcheckHost.startsWith("http") ? smartcheckHost : "https://" + smartcheckHost;
        try {
            new URIBuilder(smartcheckUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("smartcheckHost is not a valid url");
        }
        return smartcheckUrl;
    }

    private ScanResult parseScanResults(String workspace, String results) throws BuildScanResultsException {
        String sanitizedJson = JsonSanitizer.sanitize((String)results);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            ScanResult scanResult = (ScanResult)mapper.readerFor(ScanResult.class).readValue(sanitizedJson);
            return scanResult;
        }
        catch (IOException e) {
            throw new BuildScanResultsException("Failed to parse scan results.", e);
        }
    }

    public String getIconFileName() {
        return "/plugin/deepsecurity-smartcheck/images/smartcheck.png";
    }

    public String getDisplayName() {
        return "Deep Security Smart Check Scan Report";
    }

    public String getUrlName() {
        return "smartcheck-scan";
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public ScanResult getScanResult() {
        return this.scanResult;
    }

    public void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
    }

    public String getScanUIUrl() {
        return this.scanUIUrl;
    }

    public void setScanUIUrl(String scanUIUrl) {
        this.scanUIUrl = scanUIUrl;
    }

    class BuildScanResultsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BuildScanResultsException(String string) {
            super(string);
        }

        public BuildScanResultsException(String string, Throwable t) {
            super(string, t);
        }
    }
}

