/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatables;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jenkins.plugins.datatables.AsyncTableContentProvider;
import java.util.List;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public abstract class DefaultAsyncTableContentProvider
implements AsyncTableContentProvider {
    @Override
    @JavaScriptMethod
    public String getTableRows(String id) {
        return this.toJsonArray(this.getTableModel(id).getRows());
    }

    private String toJsonArray(List<Object> rows) {
        try {
            return new ObjectMapper().writeValueAsString(rows);
        }
        catch (JsonProcessingException exception) {
            throw new IllegalArgumentException(String.format("Can't convert table rows '%s' to JSON object", rows), exception);
        }
    }
}

